/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.support.CacheStrategyDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSynchronizedCacheStrategyDecorator<K, V>
extends CacheStrategyDecorator<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSynchronizedCacheStrategyDecorator.class);
    private final ConcurrentMap<K, ReadWriteLock> locks = new ConcurrentHashMap<K, ReadWriteLock>();

    public AbstractSynchronizedCacheStrategyDecorator(CacheStrategy<K, V> decorated) {
        super(decorated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(K key) {
        Validate.notNull(key);
        LOG.debug("Searching cache key: {}", key);
        V value = null;
        this.onBeforeGet(key);
        ReadWriteLock lock = this.getLockForKey(key);
        lock.readLock().lock();
        try {
            value = ((CacheStrategy)this.getDecoratedObject()).get(key);
        }
        finally {
            lock.readLock().unlock();
        }
        if (value == null) {
            lock.writeLock().lock();
            try {
                value = ((CacheStrategy)this.getDecoratedObject()).get(key);
                if (value == null) {
                    LOG.debug("Cache is empty. Loading new value...");
                    value = this.loadValue(key);
                    this.put(key, value);
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return value;
    }

    protected void onBeforeGet(K key) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(K key, V value) {
        ReadWriteLock lock = this.getLockForKey(key);
        lock.writeLock().lock();
        try {
            ((CacheStrategy)this.getDecoratedObject()).put(key, value);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private ReadWriteLock getLockForKey(K key) {
        ReadWriteLock lock = this.locks.putIfAbsent(key, new ReentrantReadWriteLock());
        return lock == null ? (ReadWriteLock)this.locks.get(key) : lock;
    }

    protected abstract V loadValue(K var1);
}

