/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.usersearches.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSearch;
import org.fao.geonet.domain.UserSearchFeaturedType;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserRepository;

public class UserSearchDto
implements Serializable {
    public static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final long serialVersionUID = -2111281874868436021L;
    private int id;
    private String url;
    private String featuredType = "";
    private String creationDate;
    private int creatorId;
    private String creator;
    private String logo;
    private Map<String, String> names = new HashMap<String, String>();
    private List<Integer> groups = new ArrayList<Integer>();

    public static UserSearchDto from(UserSearch userSearch) {
        UserSearchDto dto = new UserSearchDto();
        dto.setId(userSearch.getId());
        dto.setUrl(userSearch.getUrl());
        dto.setLogo(userSearch.getLogo());
        if (userSearch.getFeaturedType() != null) {
            dto.setFeaturedType(userSearch.getFeaturedType().asString());
        }
        dto.setCreatorId(userSearch.getCreator().getId());
        dto.setCreator(userSearch.getCreator().getUsername());
        dto.setCreationDate(ISO_DATE_FORMAT.format(userSearch.getCreationDate()));
        userSearch.getLabelTranslations().forEach((key, value) -> dto.addName((String)key, (String)value));
        userSearch.getGroups().forEach(group -> dto.addGroup(group.getId()));
        return dto;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFeaturedType() {
        return this.featuredType;
    }

    public void setFeaturedType(String featuredType) {
        this.featuredType = featuredType;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public int getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(int creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public void setNames(Map<String, String> names) {
        this.names = names;
    }

    public void addName(String lang, String name) {
        this.names.put(lang, name);
    }

    public List<Integer> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Integer> groups) {
        this.groups = groups;
    }

    public void addGroup(Integer groupId) {
        this.groups.add(groupId);
    }

    public UserSearch asUserSearch() {
        UserSearch userSearch = new UserSearch();
        userSearch.setId(this.getId());
        userSearch.setUrl(this.getUrl());
        userSearch.setLogo(this.getLogo());
        try {
            if (StringUtils.isNotEmpty((String)this.getFeaturedType()) && this.getFeaturedType().length() == 1) {
                userSearch.setFeaturedType(UserSearchFeaturedType.byChar((Character)Character.valueOf(this.getFeaturedType().charAt(0))));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            userSearch.setCreationDate(ISO_DATE_FORMAT.parse(this.getCreationDate()));
        }
        catch (Exception ex) {
            userSearch.setCreationDate(new Date());
        }
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        Optional user = userRepository.findById((Object)this.getCreatorId());
        if (user.isPresent()) {
            userSearch.setCreator((User)user.get());
        }
        this.getNames().forEach((key, value) -> userSearch.getLabelTranslations().put(key, value));
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        HashSet groups = new HashSet();
        this.getGroups().forEach(groupId -> {
            Optional g;
            if (groupId != null && (g = groupRepository.findById(groupId)).isPresent()) {
                groups.add(g.get());
            }
        });
        userSearch.setGroups(groups);
        return userSearch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearchDto that = (UserSearchDto)o;
        return this.id == that.id && this.featuredType == that.featuredType && this.creatorId == that.creatorId && this.url.equals(that.url) && this.creationDate.equals(that.creationDate) && this.creator.equals(that.creator) && Objects.equals(this.logo, that.logo) && this.names.equals(that.names) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.featuredType, this.creationDate, this.creatorId, this.creator, this.logo, this.names, this.groups);
    }
}

