/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.validation;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.validation.Errors;

public class PasswordValidationUtils {
    public static void rejectIfInvalid(Errors errors, String password) {
        SettingManager sm = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        Integer minLength = sm.getValueAsInt("system/security/passwordEnforcement/minLength");
        Integer maxLength = sm.getValueAsInt("system/security/passwordEnforcement/maxLength");
        boolean usePattern = sm.getValueAsBool("system/security/passwordEnforcement/usePattern");
        String pattern = sm.getValue("system/security/passwordEnforcement/pattern");
        if (StringUtils.isEmpty((String)password) || password.trim().length() < minLength) {
            errors.rejectValue("password", "field.length", new Object[]{(int)minLength, (int)maxLength}, "Password size should be between " + minLength + " and " + maxLength + " characters");
        }
        if (StringUtils.isNotEmpty((String)password) && password.trim().length() > maxLength) {
            errors.rejectValue("password", "field.length", new Object[]{(int)minLength, (int)maxLength}, "Password size should be between " + minLength + " and " + maxLength + " characters");
        }
        if (usePattern && !Pattern.matches(pattern, password)) {
            errors.rejectValue("password", "field.invalid", new Object[]{(int)maxLength}, "Password must contain at least 1 uppercase, 1 lowercase, 1 number and 1 symbol. Symbols include: `~!@#$%^&*()-_=+[]{}\\\\|;:'\",.<>/?');");
        }
    }
}

