/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fao.geonet.Constants;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.template.SimpleTNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeFactory;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeTextContent;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateException;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateType;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class TemplateParser {
    @Autowired
    @VisibleForTesting
    List<TNodeFactory> tnodeFactories;
    @Autowired
    @VisibleForTesting
    TextContentParser textContentParser;

    public TNode parse(Path path) {
        try {
            TNode root = this.parse(Files.readAllBytes(path), TemplateType.fromPath(path));
            root.setUnparsedSize(Files.size(path));
            return root;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
        catch (TemplateException e) {
            if (e.getCause() != null) {
                throw new TemplateException("Error when parsing " + path + ":" + e.getCause().getMessage(), e.getCause());
            }
            throw new TemplateException("Error when parsing " + path + ":" + e.getMessage(), e);
        }
    }

    public TNode parse(byte[] in, TemplateType type) {
        switch (type) {
            case XML: {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    Handler handler = new Handler();
                    InputSource source = new InputSource(new ByteArrayInputStream(in));
                    source.setEncoding(Constants.ENCODING);
                    saxParser.parse(source, (DefaultHandler)handler);
                    return handler.root;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new TemplateException(e);
                }
            }
        }
        try {
            String unparsedText = new String(in, Constants.ENCODING);
            return new TNodeTextContent(this.getSystemInfo(), this.textContentParser, this.textContentParser.parse(unparsedText));
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    protected SystemInfo getSystemInfo() {
        return SystemInfo.getInfo();
    }

    private class Handler
    extends DefaultHandler {
        public TNode root;
        public Stack<TNode> stack = new Stack();
        public char[] textContent;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.processText();
                TNodeFactory found = null;
                for (TNodeFactory factory : TemplateParser.this.tnodeFactories) {
                    if (!factory.applicable(localName, qName, attributes)) continue;
                    if (found != null) {
                        throw new TemplateException("More than one directive attribute was found on " + qName + "\nFound: " + found.getClass().getSimpleName() + " and " + factory.getClass().getSimpleName());
                    }
                    this.setCurrentNode(factory.create(localName, qName, attributes));
                    found = factory;
                }
                if (found == null) {
                    this.setCurrentNode(new SimpleTNode(TemplateParser.this.getSystemInfo(), TemplateParser.this.textContentParser, qName, attributes));
                }
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }

        private void setCurrentNode(TNode node) {
            if (this.root == null) {
                this.root = node;
            } else {
                this.stack.peek().addChild(node);
            }
            this.stack.push(node);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.processText();
            this.stack.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            int copyToStart;
            if (this.textContent != null) {
                char[] tmp = this.textContent;
                this.textContent = new char[tmp.length + length];
                System.arraycopy(tmp, 0, this.textContent, 0, tmp.length);
                copyToStart = tmp.length;
            } else {
                copyToStart = 0;
                this.textContent = new char[length];
            }
            System.arraycopy(ch, start, this.textContent, copyToStart, length);
        }

        private void processText() {
            if (this.textContent != null && !this.stack.isEmpty()) {
                try {
                    this.stack.peek().setTextContent(new String(this.textContent));
                }
                catch (IOException e) {
                    throw new TemplateException(e);
                }
            }
            this.textContent = null;
        }
    }
}

