/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.Constants;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.api.records.formatters.groovy.template.AttributesFiltered;
import org.fao.geonet.api.records.formatters.groovy.template.FileResult;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeFactoryByAttName;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;

@Component
public class TNodeFactoryTransclude
extends TNodeFactoryByAttName {
    private static final String TRANSCLUDE = "transclude";
    private static final String MODEL_KEY = "transclude-model";
    private static final String EXTRA_MODEL = "transclude-extra-model";
    private static final String REPLACE = "transclude-replace";

    protected TNodeFactoryTransclude() {
        super(TRANSCLUDE, null);
    }

    public TNodeFactoryTransclude(SystemInfo info, TextContentParser contentParser) {
        super(TRANSCLUDE, info);
        this.textContentParser = contentParser;
    }

    @Override
    public TNode create(String localName, String qName, Attributes attributes) throws IOException {
        AttributesFiltered filteredAtts = new AttributesFiltered(attributes, TRANSCLUDE, REPLACE, MODEL_KEY, EXTRA_MODEL);
        String templatePath = this.getValue(attributes, TRANSCLUDE);
        String model = this.getValue(attributes, MODEL_KEY);
        String extraModelAtts = this.getValue(attributes, EXTRA_MODEL);
        HashMap extraModel = Maps.newHashMap();
        if (extraModelAtts != null) {
            for (String att : extraModelAtts.split("\\|")) {
                String[] parts = att.split("=");
                String key = parts[0];
                String value = parts.length > 1 ? parts[1] : null;
                extraModel.put(key, value);
            }
        }
        boolean replace = this.getBooleanAttribute(attributes, REPLACE, false);
        return new TNodeTransclude(SystemInfo.getInfo((SystemInfo)this.testingInfo), this.textContentParser, qName, filteredAtts, templatePath, replace, model, extraModel);
    }

    private static class TNodeTransclude
    extends TNode {
        private final String templatePath;
        private final boolean replace;
        private final String model;
        private final Map<String, Object> extraModel;

        public TNodeTransclude(SystemInfo info, TextContentParser parser, String qName, Attributes attributes, String templatePath, boolean replace, String model, Map<String, Object> extraModel) throws IOException {
            super(info, parser, qName, attributes);
            this.replace = replace;
            this.templatePath = templatePath;
            this.model = model;
            this.extraModel = extraModel;
        }

        @Override
        protected Optional<String> canRender(TRenderContext context) {
            return Optional.absent();
        }

        @Override
        public void render(TRenderContext context) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TRenderContext sepContext = new TRenderContext(outputStream, context.getModel(true));
            if (this.replace) {
                for (TNode tNode : this.getChildren()) {
                    tNode.render(sepContext);
                }
            } else {
                super.render(sepContext);
            }
            HashMap fullModel = Maps.newHashMap();
            fullModel.putAll(context.getModel(true));
            for (Map.Entry<String, Object> entry : this.extraModel.entrySet()) {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                this.textContentParser.parse(entry.getValue().toString()).render(new TRenderContext(o, context.getModel(true)));
                fullModel.put(entry.getKey(), new String(o.toByteArray(), Constants.CHARSET));
            }
            fullModel.put(this.model, new String(outputStream.toByteArray(), Constants.CHARSET));
            Handlers handlers = TransformationContext.getContext().getHandlers();
            FileResult fileResult = handlers.fileResult(this.templatePath, fullModel);
            context.append(fileResult.toString());
        }
    }
}

