/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.MetadataBatchApproveParameter;
import org.fao.geonet.api.records.model.MetadataStatusParameter;
import org.fao.geonet.api.records.model.MetadataStatusResponse;
import org.fao.geonet.api.records.model.MetadataWorkflowStatusResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordRestoredEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordWorkflow")
@ReadWriteController
public class MetadataWorkflowApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    MetadataDraftRepository metadatadraftRepository;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    StatusActionsFactory statusActionFactory;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private MetadataRepository metadataRepository;
    static final Integer[] supportedRestoreStatuses = new Integer[]{Integer.parseInt("51"), Integer.parseInt("60"), Integer.parseInt("61"), Integer.parseInt("63")};

    @Operation(summary="Get record status history", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistory(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @RequestParam(required=false) boolean details, @Parameter(description="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllByMetadataId(metadata.getId(), Sort.by((Sort.Direction)sortOrder, (String[])new String[]{sortField}));
        List<MetadataStatusResponse> response = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
        return response;
    }

    @Operation(summary="Get record status history by type", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistoryByType(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Type", required=true) @PathVariable StatusValueType type, @RequestParam(required=false) boolean details, @Parameter(description="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), type, Sort.by((Sort.Direction)sortOrder, (String[])new String[]{sortField}));
        List<MetadataStatusResponse> response = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
        return response;
    }

    @Operation(summary="Get last workflow status for a record", description="")
    @RequestMapping(value={"/{metadataUuid}/status/workflow/last"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record status."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public MetadataWorkflowStatusResponse getStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("Only the owner of the metadata can get the status. User is not the owner of the metadata", new Object[0]));
        }
        MetadataStatus recordStatus = this.metadataStatus.getStatus(metadata.getId());
        List elStatus = this.statusValueRepository.findAllByType(StatusValueType.workflow);
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(metadata.getId());
        List reviewers = this.userRepository.findAllByGroupOwnerNameAndProfile(ids, Profile.Reviewer);
        Collections.sort(reviewers, Comparator.comparing(s -> ((User)s.two()).getName()));
        ArrayList<User> listOfReviewers = new ArrayList<User>();
        for (Pair reviewer : reviewers) {
            listOfReviewers.add((User)reviewer.two());
        }
        return new MetadataWorkflowStatusResponse(recordStatus, listOfReviewers, this.accessManager.hasEditPermission(context, metadata.getId() + ""), elStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set the records status to approved", description="")
    @RequestMapping(value={"/approve"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metadata approved ."), @ApiResponse(responseCode="400", description="Metadata workflow not enabled.")})
    @ResponseBody
    MetadataProcessingReport approve(@RequestBody MetadataBatchApproveParameter approveParameter, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (!isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata");
        }
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(approveParameter.getUuids(), approveParameter.getBucket(), ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                boolean isInvalid;
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!this.accessManager.isOwner(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSumitApproveInvalidMd");
                if (!isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata is invalid: can't be approved");
                    continue;
                }
                MetadataStatus currentStatus = this.metadataStatus.getStatus(metadata.getId());
                if (!approveParameter.isDirectApproval()) {
                    if (currentStatus == null) {
                        report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata workflow is not enabled");
                        continue;
                    }
                    if (currentStatus.getStatusValue().getId() != Integer.parseInt("4")) {
                        report.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.metadataUtils.isMetadataDraft(metadata.getId()), this.metadataUtils.isMetadataApproved(metadata.getId()), "Metadata is not in submitted status.");
                        continue;
                    }
                }
                StatusActions sa = this.statusActionFactory.createStatusActions(context);
                MetadataStatusParameter status = new MetadataStatusParameter();
                status.setStatus(Integer.parseInt("2"));
                status.setChangeMessage(approveParameter.getMessage());
                int author = context.getUserSession().getUserIdAsInt();
                MetadataStatus metadataStatus = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
                ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
                listOfStatusChange.add(metadataStatus);
                sa.onStatusChange(listOfStatusChange);
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
            }
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    @Operation(summary="Set the record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status updated."), @ApiResponse(responseCode="400", description="Metadata workflow not enabled."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Metadata status", required=true) @RequestBody(required=true) MetadataStatusParameter status, HttpServletRequest request) throws Exception {
        Metadata metadataApproved;
        boolean isInvalid;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        int author = context.getUserSession().getUserIdAsInt();
        MetadataStatus metadataStatus = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
        if (metadataStatus.getStatusValue().getType() == StatusValueType.workflow && !isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata").withMessageKey("exception.resourceNotEnabled.workflow").withDescriptionKey("exception.resourceNotEnabled.workflow.description");
        }
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("Only the owner of the metadata can set the status of this record. User is not the owner of the metadata.", new Object[0]));
        }
        boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSumitApproveInvalidMd");
        if ((status.getStatus() == Integer.parseInt("4") || status.getStatus() == Integer.parseInt("2")) && !isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
            throw new NotAllowedException("Metadata is invalid: can't be submitted or approved").withMessageKey("exception.resourceInvalid.metadata").withDescriptionKey("exception.resourceInvalid.metadata.description");
        }
        StatusActions sa = this.statusActionFactory.createStatusActions(context);
        ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
        listOfStatusChange.add(metadataStatus);
        sa.onStatusChange(listOfStatusChange);
        this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true);
        this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true);
        if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
            this.metadataIndexer.indexMetadata(String.valueOf(metadataApproved.getId()), true);
        }
    }

    @Operation(summary="Close a record task", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/close"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Task closed."), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void closeTask(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(description="Close date", required=true) @RequestParam String closeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatus = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatus == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%d', user '%s' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.update((Serializable)Integer.valueOf(metadataStatus.getId()), entity -> entity.setCloseDate(new ISODate(closeDate)));
    }

    @Operation(summary="Delete a record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status removed."), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecordStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatus = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatus == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%d', user '%s' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.delete((Object)metadataStatus);
    }

    @Operation(summary="Delete all record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status removed."), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllRecordStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        this.metadataStatusRepository.deleteAllById_MetadataId(Integer.valueOf(metadata.getId()));
    }

    @Operation(summary="Search status", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/status/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getWorkflowStatusByType(@Parameter(description="One or more types to retrieve (ie. worflow, event, task). Default is all.", required=false) @RequestParam(required=false) List<StatusValueType> type, @Parameter(description="All event details including XML changes. Responses are bigger. Default is false", required=false) @RequestParam(required=false) boolean details, @Parameter(description="Sort Order (ie. DESC or ASC). Default is none.", required=false) @RequestParam(required=false) Sort.Direction sortOrder, @Parameter(description="One or more event author. Default is all.", required=false) @RequestParam(required=false) List<Integer> author, @Parameter(description="One or more event owners. Default is all.", required=false) @RequestParam(required=false) List<Integer> owner, @Parameter(description="One or more record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> id, @Parameter(description="One or more metadata record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> record, @Parameter(description="One or more metadata uuid. Default is all.", required=false) @RequestParam(required=false) List<String> uuid, @Parameter(description="One or more status id. Default is all.", required=false) @RequestParam(required=false) List<String> statusIds, @Parameter(description="Start date", required=false) @RequestParam(required=false) String dateFrom, @Parameter(description="End date", required=false) @RequestParam(required=false) String dateTo, @Parameter(description="From page", required=false) @RequestParam(required=false, defaultValue="0") Integer from, @Parameter(description="Number of records to return", required=false) @RequestParam(required=false, defaultValue="100") Integer size, HttpServletRequest request) throws Exception {
        PageRequest pageRequest;
        Sort sortByStatusChangeDate;
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (sortOrder != null) {
            sortByStatusChangeDate = SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
            pageRequest = PageRequest.of((int)from, (int)size, (Sort)sortByStatusChangeDate);
        } else {
            sortByStatusChangeDate = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
            pageRequest = PageRequest.of((int)from, (int)size, (Sort)sortByStatusChangeDate);
        }
        List metadataStatuses = CollectionUtils.isNotEmpty(id) || CollectionUtils.isNotEmpty(uuid) || CollectionUtils.isNotEmpty(type) || CollectionUtils.isNotEmpty(author) || CollectionUtils.isNotEmpty(owner) || CollectionUtils.isNotEmpty(record) || CollectionUtils.isNotEmpty(statusIds) ? this.metadataStatusRepository.searchStatus(id, uuid, type, author, owner, record, statusIds, dateFrom, dateTo, (Pageable)pageRequest) : this.metadataStatusRepository.findAll((Pageable)pageRequest).getContent();
        return this.buildMetadataStatusResponses(metadataStatuses, details, context.getLanguage());
    }

    private MetadataStatus convertParameter(int id, String uuid, MetadataStatusParameter parameter, int author) throws Exception {
        StatusValue statusValue = (StatusValue)this.statusValueRepository.findById((Object)parameter.getStatus()).get();
        MetadataStatus metadataStatus = new MetadataStatus();
        metadataStatus.setMetadataId(id);
        metadataStatus.setUuid(uuid);
        metadataStatus.setChangeDate(new ISODate());
        metadataStatus.setUserId(author);
        metadataStatus.setStatusValue(statusValue);
        if (parameter.getChangeMessage() != null) {
            metadataStatus.setChangeMessage(parameter.getChangeMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getDueDate())) {
            metadataStatus.setDueDate(new ISODate(parameter.getDueDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getCloseDate())) {
            metadataStatus.setCloseDate(new ISODate(parameter.getCloseDate()));
        }
        if (parameter.getOwner() != null) {
            metadataStatus.setOwner(parameter.getOwner());
        }
        return metadataStatus;
    }

    @Operation(summary="Get saved content from the status record before changes", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/before"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Previous version of the record."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusBefore(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatus = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatus, State.BEFORE, request, httpSession);
    }

    @Operation(summary="Get saved content from the status record after changes")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/after"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Version of the record after changes."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusAfter(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatus = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatus, State.AFTER, request, httpSession);
    }

    @Operation(summary="Restore saved content from a status record")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/restore"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record restored."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void restoreAtStatusSave(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
        MetadataStatus metadataStatus = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        String previousStateText = this.getValidatedStateText(metadataStatus, State.BEFORE, request, httpSession);
        try {
            metadata = ApiUtils.canEditRecord(metadataStatus.getUuid(), request);
        }
        catch (ResourceNotFoundException e) {
            metadata = null;
        }
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());
        Element beforeMetadata = null;
        String xmlBefore = null;
        if (metadata != null) {
            beforeMetadata = dataMan.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
            XMLOutputter outp = new XMLOutputter();
            if (beforeMetadata != null) {
                xmlBefore = outp.outputString(beforeMetadata);
            }
            if (xmlBefore.equals(previousStateText)) {
                throw new NotAllowedException("Error recovering metadata id " + metadataUuid + ". Cannot recover record which are identical. Possibly already recovered.");
            }
        }
        IMetadataManager iMetadataManager = (IMetadataManager)context.getBean(IMetadataManager.class);
        Integer recoveredMetadataId = null;
        if (metadata != null) {
            Element md = Xml.loadString((String)previousStateText, (boolean)false);
            Element mdNoGeonetInfo = this.metadataUtils.removeMetadataInfo(md);
            iMetadataManager.updateMetadata(context, String.valueOf(metadata.getId()), mdNoGeonetInfo, false, true, true, context.getLanguage(), null, false);
            recoveredMetadataId = metadata.getId();
        } else {
            Element element = null;
            try {
                element = Xml.loadString((String)previousStateText, (boolean)false);
            }
            catch (JDOMParseException ex) {
                throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
            }
            recoveredMetadataId = this.reloadRecord(metadataStatus, element, iMetadataManager, httpSession, request);
        }
        this.dataManager.indexMetadata(String.valueOf(recoveredMetadataId), true);
        UserSession session = ApiUtils.getUserSession(request.getSession());
        if (session != null) {
            Element afterMetadata = dataMan.getMetadata(context, String.valueOf(recoveredMetadataId), false, false, false);
            XMLOutputter outp = new XMLOutputter();
            String xmlAfter = outp.outputString(afterMetadata);
            new RecordRestoredEvent(recoveredMetadataId, metadataStatus.getUuid(), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter, metadataStatus).publish((ApplicationContext)applicationContext);
        }
    }

    private List<MetadataStatusResponse> buildMetadataStatusResponses(List<MetadataStatus> listOfStatus, boolean details, String language) {
        ArrayList<MetadataStatusResponse> response = new ArrayList<MetadataStatusResponse>();
        HashMap listOfUsers = new HashMap();
        for (MetadataStatus s : listOfStatus) {
            Optional user;
            if (listOfUsers.get(s.getUserId()) == null) {
                listOfUsers.put(s.getUserId(), this.userRepository.findById((Object)s.getUserId()).get());
            }
            if (s.getOwner() == null || listOfUsers.get(s.getOwner()) != null || !(user = this.userRepository.findById((Object)s.getOwner())).isPresent()) continue;
            listOfUsers.put(s.getOwner(), user.get());
        }
        HashMap<Integer, String> titles = new HashMap<Integer, String>();
        HashMap uuids = new HashMap();
        for (MetadataStatus s : listOfStatus) {
            User owner;
            MetadataStatusResponse status = new MetadataStatusResponse(s, details);
            User author = (User)listOfUsers.get(status.getUserId());
            if (author != null) {
                status.setAuthorName(author.getName() + " " + author.getSurname());
                status.setAuthorEmail(author.getEmail());
            }
            if (s.getOwner() != null && (owner = (User)listOfUsers.get(status.getOwner())) != null) {
                status.setOwnerName(owner.getName() + " " + owner.getSurname());
                status.setOwnerEmail(owner.getEmail());
            }
            status.setDateChange(s.getChangeDate().getDateAndTime());
            if (s.getStatusValue().getType().equals((Object)StatusValueType.event)) {
                status.setCurrentStatus(this.extractCurrentStatus(s));
                status.setPreviousStatus(this.extractPreviousStatus(s));
            } else if (s.getStatusValue().getType().equals((Object)StatusValueType.task)) {
                if (s.getDueDate() != null) {
                    status.setDateDue(s.getDueDate().getDateAndTime());
                }
                if (s.getCloseDate() != null) {
                    status.setDateClose(s.getCloseDate().getDateAndTime());
                }
            }
            if (s.getTitles() != null && s.getTitles().size() > 0) {
                status.setTitle((String)s.getTitles().getOrDefault(language, s.getTitles().getOrDefault(language.substring(0, 2), s.getTitles().entrySet().iterator().next().getValue())));
            }
            if (status.getTitle() == null || status.getTitle().length() == 0) {
                String title = (String)titles.get(s.getMetadataId());
                if (title == null) {
                    try {
                        HashSet<String> fields = new HashSet<String>();
                        String titleField = "resourceTitleObject";
                        fields.add(titleField);
                        Optional metadata = this.metadataRepository.findById((Object)s.getMetadataId());
                        Map values = this.searchManager.getFieldsValues(((Metadata)metadata.get()).getUuid(), fields);
                        title = (String)values.get(titleField);
                        titles.put(s.getMetadataId(), title);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                status.setTitle(title);
            }
            status.setUuid(s.getUuid());
            response.add(status);
        }
        return response;
    }

    private String extractCurrentStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "52": {
                return s.getCurrentState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "60": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"process");
            }
            case "57": {
                List categories = ObjectJSONUtils.extractListOfFieldFromJSONString((String)s.getCurrentState(), (String)"category", (String)"name");
                StringBuffer categoriesAsString = new StringBuffer("[ ");
                for (String categoryName : categories) {
                    categoriesAsString.append(categoryName + " ");
                }
                categoriesAsString.append("]");
                return categoriesAsString.toString();
            }
            case "58": {
                return s.getCurrentState().equals("1") ? "OK" : "KO";
            }
        }
        return "";
    }

    private String extractPreviousStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "53": {
                return s.getPreviousState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
        }
        return "";
    }

    private void checkCanViewStatus(String metadata, MetadataStatus metadataStatus, HttpSession httpSession, HttpServletRequest request) throws Exception {
        UserSession userSession;
        Group groupEntity;
        Element xmlElement = null;
        try {
            xmlElement = Xml.loadString((String)metadata, (boolean)false);
        }
        catch (JDOMParseException ex) {
            throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
        }
        Element info = xmlElement.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't locate required geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator) {
            if (groupId != null) {
                List editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor);
                if (!editingGroupList.contains(Integer.valueOf(groupId))) {
                    throw new SecurityException(String.format("You can't view history from this group (" + groupOwnerName + "). User MUST be an Editor in that group", new Object[0]));
                }
            } else {
                throw new SecurityException(String.format("Error identify group where this metadata belong to. Only administrator can view this record", new Object[0]));
            }
        }
    }

    private int reloadRecord(MetadataStatus metadataStatus, Element md, IMetadataManager iMetadataManager, HttpSession httpSession, HttpServletRequest request) throws Exception {
        List editingGroupList;
        UserSession userSession;
        Group groupEntity;
        Element info = md.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't location geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        md = this.metadataUtils.removeMetadataInfo(md);
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator && groupId != null && !(editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).contains(Integer.valueOf(groupId))) {
            throw new SecurityException(String.format("You can't create a record in this group (" + groupOwnerName + "). User MUST be an Editor in that group", new Object[0]));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String schema = info.getChildText("schema");
        if (schema == null) {
            schema = this.dataManager.autodetectSchema(md);
            throw new IllegalArgumentException("Can't detect schema for metadata automatically. You could try to force the schema with the schema parameter.");
        }
        String uuid = info.getChildText("uuid");
        if (uuid == null && (uuid = this.dataManager.extractUUID(schema, md)).length() == 0) {
            throw new IllegalArgumentException("Could not locate the UUID for the document being restored.");
        }
        if (this.metadataRepository.findOneByUuid(uuid) != null) {
            throw new IllegalArgumentException(String.format("A record with UUID '%s' already exist", uuid));
        }
        String date = new ISODate().toString();
        boolean ufo = false;
        boolean indexImmediate = false;
        String metadataId = iMetadataManager.insertMetadata(context, schema, md, uuid, context.getUserSession().getUserIdAsInt(), groupId, this.settingManager.getSiteId(), MetadataType.METADATA.codeString, null, null, date, date, ufo, indexImmediate);
        int id = Integer.parseInt(metadataId);
        List categoryList = info.getChildren("category");
        if (categoryList != null && categoryList.size() > 0) {
            MetadataCategoryRepository categoryRepository = (MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class);
            for (Element cat : categoryList) {
                String catName = cat.getText();
                MetadataCategory metadataCategory = categoryRepository.findOneByName(catName);
                if (metadataCategory == null) continue;
                this.dataManager.setCategory(context, metadataId, String.valueOf(metadataCategory.getId()));
            }
        }
        return id;
    }

    private MetadataStatus getMetadataStatus(String uuidOrInternalId, int statusId, int userId, String changeDate) throws ResourceNotFoundException {
        MetadataStatus metadataStatus = uuidOrInternalId.matches("\\d+") ? this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(Integer.valueOf(uuidOrInternalId).intValue(), statusId, userId, new ISODate(changeDate)) : this.metadataStatusRepository.findOneByUuidAndStatusValue_IdAndUserIdAndChangeDate(uuidOrInternalId, statusId, userId, new ISODate(changeDate));
        if (metadataStatus == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d', status, '%d' at date '%s'", uuidOrInternalId, userId, statusId, changeDate));
        }
        return metadataStatus;
    }

    private String getValidatedStateText(MetadataStatus metadataStatus, State state, HttpServletRequest request, HttpSession httpSession) throws Exception {
        if (!StatusValueType.event.equals((Object)metadataStatus.getStatusValue().getType()) || !ArrayUtils.contains((Object[])supportedRestoreStatuses, (Object)metadataStatus.getStatusValue().getId())) {
            throw new NotAllowedException("Unsupported action on status type '" + metadataStatus.getStatusValue().getType() + "' for metadata '" + metadataStatus.getUuid() + "'. Supports status type '" + StatusValueType.event + "' with the status id '" + Arrays.toString((Object[])supportedRestoreStatuses) + "'.");
        }
        String StateText = state.equals((Object)State.AFTER) ? metadataStatus.getCurrentState() : metadataStatus.getPreviousState();
        if (StateText == null) {
            throw new ResourceNotFoundException(String.format("No data exists for previous state on metadata record '%d', user '%s' at date '%s'", metadataStatus.getUuid(), metadataStatus.getUserId(), metadataStatus.getChangeDate()));
        }
        try {
            ApiUtils.canEditRecord(metadataStatus.getUuid(), request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        catch (ResourceNotFoundException e) {
            this.checkCanViewStatus(StateText, metadataStatus, httpSession, request);
        }
        return StateText;
    }

    private static enum State {
        BEFORE,
        AFTER;

    }
}

