/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.model.GroupOperations;
import org.fao.geonet.api.records.model.GroupPrivilege;
import org.fao.geonet.api.records.model.SharingParameter;
import org.fao.geonet.api.records.model.SharingResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordGroupOwnerChangeEvent;
import org.fao.geonet.events.history.RecordOwnerChangeEvent;
import org.fao.geonet.events.history.RecordPrivilegesChangeEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.util.WorkflowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@PreAuthorize(value="hasAuthority('Editor')")
@Controller(value="recordSharing")
@ReadWriteController
public class MetadataSharingApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager sm;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataValidator validator;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    @Qualifier(value="publicationConfig")
    private Map publicationConfig;

    public static Vector<OperationAllowedId> retrievePrivileges(ServiceContext context, String id, Integer userId, Integer groupId) throws Exception {
        OperationAllowedRepository opAllowRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
        int iMetadataId = Integer.parseInt(id);
        Specification spec = Specification.where((Specification)OperationAllowedSpecs.hasMetadataId((int)iMetadataId));
        if (groupId != null) {
            spec = spec.and(OperationAllowedSpecs.hasGroupId((int)groupId));
        }
        List operationsAllowed = opAllowRepo.findAllWithOwner(userId.intValue(), com.google.common.base.Optional.of((Object)spec));
        Vector<OperationAllowedId> result = new Vector<OperationAllowedId>();
        for (OperationAllowed operationAllowed : operationsAllowed) {
            result.add(operationAllowed.getId());
        }
        return result;
    }

    @Operation(summary="Set privileges for ALL group to publish the metadata for all users.")
    @RequestMapping(value={"/{metadataUuid}/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void publish(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        this.shareMetadataWithAllGroup(metadataUuid, true, session, request);
    }

    @Operation(summary="Unsets privileges for ALL group to publish the metadata for all users.")
    @RequestMapping(value={"/{metadataUuid}/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void unpublish(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        this.shareMetadataWithAllGroup(metadataUuid, false, session, request);
    }

    @Operation(summary="Set record sharing", description="Privileges are assigned by group. User needs to be able to edit a record to set sharing settings. For reserved group (ie. Internet, Intranet & Guest), user MUST be reviewer of one group. For other group, if Only set privileges to user's groups is set in catalog configuration user MUST be a member of the group.<br/>Clear first allows to unset all operations first before setting the new ones.Clear option does not remove reserved groups operation if user is not an administrator, a reviewer or the owner of the record.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/publishing/managing-privileges.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void share(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        boolean isAdmin;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean skipAllReservedGroup = false;
        UserSession us = ApiUtils.getUserSession(session);
        boolean bl = isAdmin = Profile.Administrator == us.getProfile();
        if (!isAdmin && !this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
            skipAllReservedGroup = true;
        }
        List operationList = this.operationRepository.findAll();
        HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
        for (org.fao.geonet.domain.Operation o : operationList) {
            operationMap.put(o.getName(), o.getId());
        }
        List<GroupOperations> privileges = sharing.getPrivileges();
        this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, null, request);
        this.metadataIndexer.indexMetadataPrivileges(metadata.getUuid(), metadata.getId());
    }

    @Operation(summary="Publish one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport publish(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        SharingParameter sharing = this.buildSharingForPublicationConfig(true);
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    @Operation(summary="Un-publish one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport unpublish(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        SharingParameter sharing = this.buildSharingForPublicationConfig(false);
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    @Operation(summary="Set sharing settings for one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport share(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    private void setOperations(SharingParameter sharing, DataManager dataMan, ServiceContext context, ApplicationContext appContext, AbstractMetadata metadata, Map<String, Integer> operationMap, List<GroupOperations> privileges, Integer userId, boolean skipAllReservedGroup, MetadataProcessingReport report, HttpServletRequest request) throws Exception {
        if (privileges != null) {
            MetadataStatus mdStatus;
            Optional groupOwner;
            boolean isGroupWithEnabledWorkflow;
            boolean sharingChanges = false;
            boolean allowPublishInvalidMd = this.sm.getValueAsBool("metadata/workflow/allowPublishInvalidMd");
            boolean allowPublishNonApprovedMd = this.sm.getValueAsBool("metadata/workflow/allowPublishNonApprovedMd");
            boolean isMdWorkflowEnable = this.sm.getValueAsBool("metadata/workflow/enable");
            Integer groupOwnerId = metadata.getSourceInfo().getGroupOwner();
            if (isMdWorkflowEnable && groupOwnerId != null && (isGroupWithEnabledWorkflow = WorkflowUtil.isGroupWithEnabledWorkflow((String)((Group)(groupOwner = this.groupRepository.findById((Object)groupOwnerId)).get()).getName())) && (mdStatus = this.metadataStatus.getStatus(metadata.getId())) != null && mdStatus.getStatusValue().getId() == Integer.parseInt("3")) {
                List allGroupOps = privileges.stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).collect(Collectors.toList());
                for (GroupOperations p2 : allGroupOps) {
                    if (!p2.getOperations().containsValue(true)) continue;
                    throw new Exception(String.format("Retired metadata %s can't be published.", metadata.getUuid()));
                }
            }
            SharingResponse sharingBefore = this.getRecordSharingSettings(metadata.getUuid(), request.getSession(), request);
            if (sharing.isClear()) {
                this.dataManager.deleteMetadataOper(context, String.valueOf(metadata.getId()), skipAllReservedGroup);
            }
            block3: for (GroupOperations p3 : privileges) {
                for (Map.Entry<String, Boolean> o : p3.getOperations().entrySet()) {
                    Integer opId = operationMap.get(o.getKey());
                    if (opId.intValue() == ReservedOperation.editing.getId() && ReservedGroup.isReserved((int)p3.getGroup())) continue;
                    if (o.getValue().booleanValue()) {
                        if (p3.getGroup().intValue() == ReservedGroup.all.getId()) {
                            try {
                                this.checkCanPublishToAllGroup(context, dataMan, metadata, allowPublishInvalidMd, allowPublishNonApprovedMd);
                            }
                            catch (Exception ex) {
                                if (report != null) {
                                    report.addMetadataError(metadata, ex.getMessage());
                                    continue block3;
                                }
                                throw ex;
                            }
                        }
                        dataMan.setOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                        sharingChanges = true;
                        continue;
                    }
                    if (sharing.isClear() || o.getValue().booleanValue()) continue;
                    dataMan.unsetOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                    sharingChanges = true;
                }
            }
            if (sharingChanges) {
                new RecordPrivilegesChangeEvent(Integer.valueOf(metadata.getId()), userId, ObjectJSONUtils.convertObjectInJsonObject(sharingBefore.getPrivileges(), (String)"sharing"), ObjectJSONUtils.convertObjectInJsonObject(privileges, (String)"sharing")).publish(appContext);
            }
        }
    }

    @Operation(summary="Get record sharing settings", description="Return current sharing options for a record.")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The record sharing settings."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SharingResponse getRecordSharingSettings(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(session);
        SharingResponse sharingResponse = new SharingResponse();
        sharingResponse.setOwner(userSession.getUserId());
        Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
        if (groupOwner != null) {
            sharingResponse.setGroupOwner(String.valueOf(groupOwner));
        }
        Set userGroups = this.accessManager.getUserGroups(userSession, context.getIpAddress(), false);
        List elGroup = this.groupRepository.findAll();
        List allOperations = this.operationRepository.findAll();
        ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
        if (elGroup != null) {
            for (Group g : elGroup) {
                GroupPrivilege groupPrivilege = new GroupPrivilege();
                groupPrivilege.setGroup(g.getId());
                groupPrivilege.setReserved(g.isReserved());
                groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
                Specification hasGroupId = UserGroupSpecs.hasGroupId((Integer)g.getId());
                Specification hasUserId = UserGroupSpecs.hasUserId((int)userSession.getUserIdAsInt());
                Specification hasUserIdAndGroupId = Specification.where((Specification)hasGroupId).and(hasUserId);
                List userGroupEntities = this.userGroupRepository.findAll(hasUserIdAndGroupId);
                ArrayList<Profile> userGroupProfile = new ArrayList<Profile>();
                for (UserGroup ug : userGroupEntities) {
                    userGroupProfile.add(ug.getProfile());
                }
                groupPrivilege.setUserProfile(userGroupProfile);
                Specification hasGroupIdAndMetadataId = Specification.where((Specification)OperationAllowedSpecs.hasGroupId((int)g.getId())).and(OperationAllowedSpecs.hasMetadataId((int)metadata.getId()));
                List operationAllowedForGroup = this.operationAllowedRepository.findAll(hasGroupIdAndMetadataId);
                HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
                for (org.fao.geonet.domain.Operation o : allOperations) {
                    boolean operationSetForGroup = false;
                    for (OperationAllowed operationAllowed : operationAllowedForGroup) {
                        if (o.getId() != operationAllowed.getId().getOperationId()) continue;
                        operationSetForGroup = true;
                        break;
                    }
                    operations.put(o.getName(), operationSetForGroup);
                }
                groupPrivilege.setOperations(operations);
                groupPrivileges.add(groupPrivilege);
            }
        }
        sharingResponse.setPrivileges(groupPrivileges);
        return sharingResponse;
    }

    @Operation(summary="Set record group", description="A record is related to one group.")
    @RequestMapping(value={"/{metadataUuid}/group"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Record group updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void setRecordGroup(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Group identifier", required=true) @RequestBody(required=true) Integer groupIdentifier, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Group group = (Group)this.groupRepository.findById((Object)groupIdentifier).get();
        if (group == null) {
            throw new ResourceNotFoundException(String.format("Group with identifier '%s' not found.", groupIdentifier));
        }
        Integer previousGroup = metadata.getSourceInfo().getGroupOwner();
        Group oldGroup = null;
        if (previousGroup != null) {
            oldGroup = (Group)this.groupRepository.findById((Object)previousGroup).get();
        }
        metadata.getSourceInfo().setGroupOwner(groupIdentifier);
        this.metadataManager.save(metadata);
        this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true);
        new RecordGroupOwnerChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)group, (String)"owner")).publish((ApplicationContext)appContext);
    }

    @Operation(summary="Get record sharing settings", description="")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return a default array of group and operations that can be used to set record sharing properties."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public SharingResponse getSharingSettings(@Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(session);
        SharingResponse sharingResponse = new SharingResponse();
        sharingResponse.setOwner(userSession.getUserId());
        List allOperations = this.operationRepository.findAll();
        Set userGroups = this.accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        List elGroup = this.groupRepository.findAll();
        ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
        for (Group g : elGroup) {
            GroupPrivilege groupPrivilege = new GroupPrivilege();
            groupPrivilege.setGroup(g.getId());
            groupPrivilege.setReserved(g.isReserved());
            groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
            HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
            for (org.fao.geonet.domain.Operation o : allOperations) {
                operations.put(o.getName(), false);
            }
            groupPrivilege.setOperations(operations);
            groupPrivileges.add(groupPrivilege);
        }
        sharingResponse.setPrivileges(groupPrivileges);
        return sharingResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set group and owner for one or more records", description="")
    @RequestMapping(value={"/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records group and owner updated"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport setGroupAndOwner(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, uuid, session);
            }
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set record group and owner", description="")
    @RequestMapping(value={"/{metadataUuid}/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Record group and owner updated"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport setRecordOwnership(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @Parameter(description="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            report.setTotalRecords(1);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, metadataUuid, session);
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    private void updateOwnership(Integer groupIdentifier, Integer userIdentifier, MetadataProcessingReport report, DataManager dataManager, AccessManager accessMan, ServiceContext serviceContext, List<String> listOfUpdatedRecords, String uuid, HttpSession session) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
        if (metadata == null) {
            report.incrementNullRecords();
        } else if (!accessMan.canEdit(serviceContext, String.valueOf(metadata.getId()))) {
            report.addNotEditableMetadataId(metadata.getId());
        } else {
            List idList = this.metadataUtils.findAllIdsBy(MetadataSpecs.hasMetadataUuid((String)uuid));
            if (idList.size() > 1) {
                report.setTotalRecords(report.getNumberOfRecords() + 1);
            }
            for (Integer mdId : idList) {
                if (mdId.intValue() != metadata.getId()) {
                    metadata = this.metadataUtils.findOne(mdId.intValue());
                }
                Integer sourceUsr = metadata.getSourceInfo().getOwner();
                Integer sourceGrp = metadata.getSourceInfo().getGroupOwner();
                Vector<OperationAllowedId> sourcePriv = MetadataSharingApi.retrievePrivileges(serviceContext, String.valueOf(metadata.getId()), sourceUsr, sourceGrp);
                Integer groupIdentifierUsed = groupIdentifier;
                if (ReservedGroup.isReserved((int)groupIdentifier)) {
                    groupIdentifierUsed = sourceGrp;
                    report.addMetadataInfos(metadata, String.format("Reserved group '%s' on metadata '%s' is not allowed. Group owner will not be changed.", groupIdentifier, metadata.getUuid()));
                }
                if (sourcePriv.size() == 0) {
                    dataManager.copyDefaultPrivForGroup(serviceContext, String.valueOf(metadata.getId()), String.valueOf(groupIdentifierUsed), false);
                    report.addMetadataInfos(metadata, String.format("No privileges for user '%s' on metadata '%s', so setting default privileges", sourceUsr, metadata.getUuid()));
                } else {
                    for (OperationAllowedId priv : sourcePriv) {
                        if (sourceGrp != null) {
                            dataManager.unsetOperation(serviceContext, metadata.getId(), sourceGrp.intValue(), priv.getOperationId());
                        }
                        dataManager.setOperation(serviceContext, metadata.getId(), groupIdentifierUsed.intValue(), priv.getOperationId());
                    }
                }
                Long metadataId = metadata.getId();
                ConfigurableApplicationContext context = ApplicationContextHolder.get();
                if (!Objects.equals(groupIdentifierUsed, sourceGrp)) {
                    Group newGroup = (Group)this.groupRepository.findById((Object)groupIdentifierUsed).get();
                    Group oldGroup = sourceGrp == null ? null : (Group)this.groupRepository.findById((Object)sourceGrp).get();
                    new RecordGroupOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), sourceGrp == null ? null : ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newGroup, (String)"owner")).publish((ApplicationContext)context);
                }
                if (!Objects.equals(userIdentifier, sourceUsr)) {
                    User newOwner = (User)this.userRepository.findById((Object)userIdentifier).get();
                    User oldOwner = (User)this.userRepository.findById((Object)sourceUsr).get();
                    new RecordOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldOwner, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newOwner, (String)"owner")).publish((ApplicationContext)context);
                }
                dataManager.updateMetadataOwner(metadata.getId(), String.valueOf(userIdentifier), String.valueOf(groupIdentifierUsed));
                report.addMetadataId(metadata.getId());
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(metadata.getId() + "");
            }
        }
    }

    private void checkCanPublishToAllGroup(ServiceContext context, DataManager dm, AbstractMetadata metadata, boolean allowPublishInvalidMd, boolean allowPublishNonApprovedMd) throws Exception {
        String statusId;
        boolean isApproved;
        MetadataStatus metadataStatus;
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
        IMetadataValidator validator = (IMetadataValidator)context.getBean(IMetadataValidator.class);
        IMetadataStatus metadataStatusRepository = (IMetadataStatus)context.getBean(IMetadataStatus.class);
        if (!allowPublishInvalidMd) {
            boolean isInvalid;
            boolean hasValidation;
            boolean bl = hasValidation = metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
            if (!hasValidation) {
                validator.doValidate(metadata, context.getLanguage());
                dm.indexMetadata(metadata.getId() + "", true);
            }
            boolean bl2 = isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
            if (isInvalid) {
                throw new Exception("The metadata " + metadata.getUuid() + " it's not valid, can't be published.");
            }
        }
        if (!allowPublishNonApprovedMd && (metadataStatus = metadataStatusRepository.getStatus(metadata.getId())) != null && !(isApproved = (statusId = metadataStatus.getStatusValue().getId() + "").equals("2"))) {
            throw new Exception("The metadata " + metadata.getUuid() + " it's not approved, can't be published.");
        }
    }

    private void shareMetadataWithAllGroup(String metadataUuid, boolean publish, HttpSession session, HttpServletRequest request) throws Exception {
        boolean isPublishForbiden;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession us = ApiUtils.getUserSession(session);
        boolean isAdmin = Profile.Administrator == us.getProfile();
        boolean isMdGroupReviewer = this.accessManager.getReviewerGroups(us).contains(metadata.getSourceInfo().getGroupOwner());
        boolean isReviewOperationAllowedOnMdForUser = this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()));
        boolean bl = isPublishForbiden = !isMdGroupReviewer && !isAdmin && !isReviewOperationAllowedOnMdForUser;
        if (isPublishForbiden) {
            throw new Exception(String.format("User not allowed to publish the metadata %s. You need to be administrator, or reviewer of the metadata group or reviewer with edit privilege on the metadata.", metadataUuid));
        }
        DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        OperationRepository operationRepository = (OperationRepository)appContext.getBean(OperationRepository.class);
        List operationList = operationRepository.findAll();
        HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
        for (org.fao.geonet.domain.Operation o : operationList) {
            operationMap.put(o.getName(), o.getId());
        }
        SharingParameter sharing = this.buildSharingForPublicationConfig(publish);
        List<GroupOperations> privileges = sharing.getPrivileges();
        this.setOperations(sharing, dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), true, null, request);
        dataManager.indexMetadata(String.valueOf(metadata.getId()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataProcessingReport shareSelection(String[] uuids, String bucket, SharingParameter sharing, HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            DataManager dataMan = (DataManager)appContext.getBean(DataManager.class);
            AccessManager accessMan = (AccessManager)appContext.getBean(AccessManager.class);
            IMetadataUtils metadataRepository = (IMetadataUtils)appContext.getBean(IMetadataUtils.class);
            UserSession us = ApiUtils.getUserSession(session);
            boolean isAdmin = Profile.Administrator == us.getProfile();
            ServiceContext context = ApiUtils.createServiceContext(request);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                AbstractMetadata metadata = metadataRepository.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                boolean skipAllReservedGroup = false;
                if (!isAdmin && accessMan.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
                    skipAllReservedGroup = true;
                }
                OperationRepository operationRepository = (OperationRepository)appContext.getBean(OperationRepository.class);
                List operationList = operationRepository.findAll();
                HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
                for (org.fao.geonet.domain.Operation o : operationList) {
                    operationMap.put(o.getName(), o.getId());
                }
                List<GroupOperations> privileges = sharing.getPrivileges();
                this.setOperations(sharing, dataMan, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request);
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
            }
            dataMan.flush();
            dataMan.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    private SharingParameter buildSharingForPublicationConfig(boolean publish) {
        SharingParameter sharing = new SharingParameter();
        sharing.setClear(false);
        ArrayList<GroupOperations> privilegesList = new ArrayList<GroupOperations>();
        for (Map.Entry e : this.publicationConfig.entrySet()) {
            GroupOperations privAllGroup = new GroupOperations();
            privAllGroup.setGroup(Integer.parseInt((String)e.getKey()));
            HashMap<String, Boolean> operations = new HashMap<String, Boolean>();
            for (Object operation : (Object[])e.getValue()) {
                operations.put((String)operation, publish);
            }
            privAllGroup.setOperations(operations);
            privilegesList.add(privAllGroup);
        }
        sharing.setPrivileges(privilegesList);
        return sharing;
    }

    public Map getPublicationConfig() {
        return this.publicationConfig;
    }

    public void setPublicationConfig(Map publicationConfig) {
        this.publicationConfig = publicationConfig;
    }
}

