/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.ListNodesInEnvironment;
import org.jclouds.chef.strategy.internal.BaseListNodesImpl;
import org.jclouds.logging.Logger;

@Singleton
public class ListNodesInEnvironmentImpl
extends BaseListNodesImpl
implements ListNodesInEnvironment {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListNodesInEnvironmentImpl(ChefApi api) {
        super(api);
    }

    @Override
    public Iterable<? extends Node> execute(String environmentName) {
        return super.execute(this.api.listNodesInEnvironment(environmentName));
    }

    @Override
    public Iterable<? extends Node> execute(ExecutorService executor, String environmentName) {
        return this.executeConcurrently(MoreExecutors.listeningDecorator((ExecutorService)executor), environmentName);
    }

    private Iterable<? extends Node> executeConcurrently(ListeningExecutorService executor, String environmentName) {
        return super.executeConcurrently(executor, this.api.listNodesInEnvironment(environmentName));
    }
}

