/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.client.security.user.privileges.Role;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public final class PutRoleRequest
implements Validatable,
ToXContentObject {
    private final Role role;
    private final RefreshPolicy refreshPolicy;

    public PutRoleRequest(Role role, @Nullable RefreshPolicy refreshPolicy) {
        this.role = Objects.requireNonNull(role);
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public Role getRole() {
        return this.role;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.refreshPolicy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PutRoleRequest other = (PutRoleRequest)obj;
        return this.refreshPolicy == other.getRefreshPolicy() && Objects.equals(this.role, other.role);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.role.getApplicationPrivileges() != null) {
            builder.field(Role.APPLICATIONS.getPreferredName(), this.role.getApplicationPrivileges());
        }
        if (this.role.getClusterPrivileges() != null) {
            builder.field(Role.CLUSTER.getPreferredName(), this.role.getClusterPrivileges());
        }
        if (this.role.getGlobalPrivileges() != null) {
            builder.field(Role.GLOBAL.getPreferredName(), (ToXContent)this.role.getGlobalPrivileges());
        }
        if (this.role.getIndicesPrivileges() != null) {
            builder.field(Role.INDICES.getPreferredName(), this.role.getIndicesPrivileges());
        }
        if (this.role.getMetadata() != null) {
            builder.field(Role.METADATA.getPreferredName(), this.role.getMetadata());
        }
        if (this.role.getRunAsPrivilege() != null) {
            builder.field(Role.RUN_AS.getPreferredName(), this.role.getRunAsPrivilege());
        }
        return builder.endObject();
    }
}

