/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.core.TimeValue;

public class DeleteDataFrameAnalyticsRequest
implements Validatable {
    private final String id;
    private Boolean force;
    private TimeValue timeout;

    public DeleteDataFrameAnalyticsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteDataFrameAnalyticsRequest other = (DeleteDataFrameAnalyticsRequest)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.force, other.force) && Objects.equals(this.timeout, other.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.force, this.timeout);
    }
}

