/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.converter.BooleanToYNConverter;
import org.fao.geonet.entitylistener.LinkStatusEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="LinkStatus", indexes={@Index(name="idx_linkstatus_isFailing", columnList="failing")})
@EntityListeners(value={LinkStatusEntityListenerManager.class})
@SequenceGenerator(name="linkstatus_id_seq", initialValue=1, allocationSize=1)
public class LinkStatus
extends GeonetEntity
implements Comparable<LinkStatus> {
    static final String ID_SEQ_NAME = "linkstatus_id_seq";
    public static final String TABLE_NAME = "LinkStatus";
    public static final String ID_COLUMN_NAME = "id";
    public static final String CHECK_DATE_COLUMN_NAME = "checkDate";
    private int id;
    private Link link;
    private ISODate checkDate = new ISODate();
    private Boolean isFailing = Boolean.TRUE;
    private String statusValue;
    private String statusInfo;
    private String batchKey;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="linkstatus_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this.id;
    }

    public LinkStatus setId(int id) {
        this.id = id;
        return this;
    }

    @ManyToOne(cascade={CascadeType.DETACH, CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinColumn(name="link", referencedColumnName="id", nullable=false)
    @JsonIgnore
    public Link getLink() {
        return this.link;
    }

    public LinkStatus setLink(Link link) {
        this.link = link;
        return this;
    }

    @Column(nullable=false)
    public String getStatusValue() {
        return this.statusValue;
    }

    public LinkStatus setStatusValue(String statusValue) {
        this.statusValue = statusValue;
        return this;
    }

    @Column(nullable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    public String getStatusInfo() {
        return this.statusInfo;
    }

    public LinkStatus setStatusInfo(String statusInfo) {
        this.statusInfo = statusInfo;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="checkDate", length=30))
    public ISODate getCheckDate() {
        return this.checkDate;
    }

    public LinkStatus setCheckDate(ISODate checkDate) {
        this.checkDate = checkDate;
        return this;
    }

    @Column(name="failing", nullable=false, length=1, columnDefinition="CHAR(1) DEFAULT 'y'")
    @Convert(converter=BooleanToYNConverter.class)
    public Boolean isFailing() {
        if (this.isFailing == null) {
            this.isFailing = true;
        }
        return this.isFailing;
    }

    public LinkStatus setFailing(Boolean isFailing) {
        this.isFailing = isFailing;
        return this;
    }

    @Column(nullable=true)
    public String getBatchKey() {
        return this.batchKey;
    }

    public void setBatchKey(String batchKey) {
        this.batchKey = batchKey;
    }

    public String toString() {
        return "LinkStatus{" + this.id + ", link=" + (this.link == null ? "null" : Integer.valueOf(this.link.getId())) + ", isFailing=" + this.isFailing + ", checkDate=" + this.checkDate + ", statusValue=" + this.statusValue + ", statusInfo=" + this.statusInfo + ", batchKey=" + this.batchKey + '}';
    }

    @Override
    public int compareTo(LinkStatus linkStatus) {
        return linkStatus.checkDate.compareTo(this.checkDate);
    }
}

