/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.entitylistener.AddressEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={AddressEntityListenerManager.class})
@SequenceGenerator(name="address_id_seq", initialValue=100, allocationSize=1)
public class Address
extends GeonetEntity
implements Serializable {
    static final String ID_SEQ_NAME = "address_id_seq";
    private static final int ZIP_COLUMN_LENGTH = 16;
    private int _id;
    private String _address;
    private String _city;
    private String _state;
    private String _zip;
    private String _country;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="address_id_seq")
    public int getId() {
        return this._id;
    }

    public Address setId(int id) {
        this._id = id;
        return this;
    }

    public String getAddress() {
        return this._address;
    }

    public Address setAddress(String address) {
        this._address = address;
        return this;
    }

    public String getCity() {
        return this._city;
    }

    public Address setCity(String city) {
        this._city = city;
        return this;
    }

    public String getState() {
        return this._state;
    }

    public Address setState(String state) {
        this._state = state;
        return this;
    }

    @Column(length=16)
    public String getZip() {
        return this._zip;
    }

    public Address setZip(String zip) {
        this._zip = zip;
        return this;
    }

    public String getCountry() {
        return this._country;
    }

    public Address setCountry(String iso2CountryCode) {
        this._country = iso2CountryCode;
        return this;
    }

    public void mergeAddress(Address otherAddress, boolean mergeNullData) {
        if (mergeNullData || StringUtils.isNotBlank((String)otherAddress.getAddress())) {
            this.setAddress(otherAddress.getAddress());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherAddress.getCity())) {
            this.setCity(otherAddress.getCity());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherAddress.getState())) {
            this.setState(otherAddress.getState());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherAddress.getZip())) {
            this.setZip(otherAddress.getZip());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherAddress.getCountry())) {
            this.setCountry(otherAddress.getCountry());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this._id != address._id) {
            return false;
        }
        if (this._address != null ? !this._address.equals(address._address) : address._address != null) {
            return false;
        }
        if (this._city != null ? !this._city.equals(address._city) : address._city != null) {
            return false;
        }
        if (this._country != null ? !this._country.equals(address._country) : address._country != null) {
            return false;
        }
        if (this._state != null ? !this._state.equals(address._state) : address._state != null) {
            return false;
        }
        return !(this._zip != null ? !this._zip.equals(address._zip) : address._zip != null);
    }

    public int hashCode() {
        int result = this._id;
        result = 31 * result + (this._address != null ? this._address.hashCode() : 0);
        result = 31 * result + (this._city != null ? this._city.hashCode() : 0);
        result = 31 * result + (this._state != null ? this._state.hashCode() : 0);
        result = 31 * result + (this._zip != null ? this._zip.hashCode() : 0);
        result = 31 * result + (this._country != null ? this._country.hashCode() : 0);
        return result;
    }
}

