/*
 * Decompiled with CFR 0.152.
 */
package v402;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.migration.DatabaseMigrationException;
import org.fao.geonet.utils.DateUtil;
import org.fao.geonet.utils.Log;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DateTimeMigrationTask
extends DatabaseMigrationTask {
    private static final Logger LOGGER = Log.createLogger((String)"geonetwork.databasemigration");
    private static final int BATCH_SIZE = 50;

    public void update(Connection connection) throws SQLException, DatabaseMigrationException {
        try {
            DataSource ds = (DataSource)this.applicationContext.getBean(DataSource.class);
            NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(ds);
            this.updateMetadataTable(jdbcTemplate);
            this.updateMetadataDraftTable(jdbcTemplate);
            this.updateHarvestHistoryTable(jdbcTemplate);
            this.updateLinkTable(jdbcTemplate);
            this.updateLinkStatusTable(jdbcTemplate);
            this.updateMetadataStatusTable(jdbcTemplate);
            this.updateMetadataValidationTable(jdbcTemplate);
            this.updateSourceTable(jdbcTemplate);
            this.updateUserTable(jdbcTemplate);
            this.updateMetadataUploadTable(jdbcTemplate);
            this.updateMetadataDownloadTable(jdbcTemplate);
        }
        catch (Exception e) {
            LOGGER.error("Error in DatabaseMigrationTask: " + e.getMessage());
            LOGGER.error((Throwable)e);
            throw new DatabaseMigrationException((Throwable)e);
        }
    }

    private void updateMetadataDraftTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of MetadataDraft");
        String getAllMetadataDraftSql = "SELECT * FROM MetadataDraft";
        String updateMetadataDraftSql = String.format("UPDATE %s SET %s=:CHANGE_DATE_VALUE, %s=:CREATE_DATE_VALUE WHERE %s=:ID_VALUE", "MetadataDraft", "changedate", "createdate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("CHANGE_DATE_VALUE", "changedate");
        parametersMap.put("CREATE_DATE_VALUE", "createdate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM MetadataDraft", updateMetadataDraftSql, primaryKeyMap, parametersMap);
    }

    private void updateMetadataDownloadTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of MetadataFileDownloads");
        String getAllMetadataDownloadSql = "SELECT * FROM MetadataFileDownloads";
        String updateMetadataDownloadSql = String.format("UPDATE %s SET %s=:DOWNLOAD_DATE_VALUE WHERE %s=:ID_VALUE", "MetadataFileDownloads", "downloadDate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("DOWNLOAD_DATE_VALUE", "downloadDate");
        LinkedHashMap<String, SqlParameter> primaryKey = new LinkedHashMap<String, SqlParameter>();
        primaryKey.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM MetadataFileDownloads", updateMetadataDownloadSql, primaryKey, parametersMap);
    }

    private void updateMetadataUploadTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of MetadataFileUploads");
        String getAllMetadataUploadSql = "SELECT * FROM MetadataFileUploads";
        String updateMetadataUploadSql = String.format("UPDATE %s SET %s=:UPLOAD_DATE_VALUE, %s=:DELETED_DATE_VALUE WHERE %s=:ID_VALUE", "MetadataFileUploads", "uploadDate", "deletedDate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("UPLOAD_DATE_VALUE", "uploadDate");
        parametersMap.put("DELETED_DATE_VALUE", "deletedDate");
        LinkedHashMap<String, SqlParameter> primaryKey = new LinkedHashMap<String, SqlParameter>();
        primaryKey.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM MetadataFileUploads", updateMetadataUploadSql, primaryKey, parametersMap);
    }

    private void updateUserTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of Users");
        String getAllUserSql = "SELECT * FROM Users";
        String updateUserSql = String.format("UPDATE %s SET %s=:LAST_LOGIN_DATE_VALUE WHERE %s=:ID_VALUE", "Users", "lastLoginDate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("LAST_LOGIN_DATE_VALUE", "lastLoginDate");
        LinkedHashMap<String, SqlParameter> primaryKey = new LinkedHashMap<String, SqlParameter>();
        primaryKey.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM Users", updateUserSql, primaryKey, parametersMap);
    }

    private void updateSourceTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of Sources");
        String getAllSourceSql = "SELECT * FROM Sources";
        String updateSourceSql = String.format("UPDATE %s SET %s=:CREATE_DATE_VALUE WHERE %s=:ID_VALUE", "Sources", "creationDate", "uuid");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("CREATE_DATE_VALUE", "creationDate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("uuid", 12));
        this.processTable(jdbcTemplate, "SELECT * FROM Sources", updateSourceSql, primaryKeyMap, parametersMap);
    }

    private void updateMetadataValidationTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of Validation");
        String getAllMdValidationSql = "SELECT * FROM Validation";
        String updateMdValidationSql = String.format("UPDATE %s SET %s=:VALIDATION_DATE_VALUE WHERE %s=:METADATA_ID_VALUE AND %s=:VALIDATION_TYPE_VALUE", "Validation", "valDate", "metadataId", "valType");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("VALIDATION_DATE_VALUE", "valDate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("METADATA_ID_VALUE", new SqlParameter("metadataId", 4));
        primaryKeyMap.put("VALIDATION_TYPE_VALUE", new SqlParameter("valType", 12));
        this.processTable(jdbcTemplate, "SELECT * FROM Validation", updateMdValidationSql, primaryKeyMap, parametersMap);
    }

    private void updateMetadataStatusTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of MetadataStatus");
        String getAllMdStatusSql = String.format("SELECT * FROM %s", "MetadataStatus");
        String updateMdStatusSql = String.format("UPDATE %s SET %s=:CLOSE_DATE_VALUE, %s=:CHANGE_DATE_VALUE, %s=:DUE_DATE_VALUE WHERE %s=:CHANGE_DATE_ORIGINAL_VALUE AND %s=:METADATA_ID_VALUE AND %s=:STATUS_ID_VALUE AND %s=:USER_ID_VALUE", "MetadataStatus", "closeDate", "changeDate", "dueDate", "changeDate", "metadataId", "statusId", "userId");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("CLOSE_DATE_VALUE", "closeDate");
        parametersMap.put("CHANGE_DATE_VALUE", "changeDate");
        parametersMap.put("DUE_DATE_VALUE", "dueDate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("CHANGE_DATE_ORIGINAL_VALUE", new SqlParameter("changeDate", 12));
        primaryKeyMap.put("METADATA_ID_VALUE", new SqlParameter("metadataId", 4));
        primaryKeyMap.put("STATUS_ID_VALUE", new SqlParameter("statusId", 4));
        primaryKeyMap.put("USER_ID_VALUE", new SqlParameter("userId", 4));
        this.processTable(jdbcTemplate, getAllMdStatusSql, updateMdStatusSql, primaryKeyMap, parametersMap);
    }

    private void updateLinkStatusTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of LinkStatus");
        String getAllLinkStatusSql = "SELECT * FROM LinkStatus";
        String updateLinkStatusSql = String.format("UPDATE %s SET %s=:CHECK_DATE_VALUE WHERE %s=:ID_VALUE", "LinkStatus", "checkDate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("CHECK_DATE_VALUE", "checkDate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM LinkStatus", updateLinkStatusSql, primaryKeyMap, parametersMap);
    }

    private void updateLinkTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of Links");
        String getAllLinkSql = "SELECT * FROM Links";
        String updateLinkSql = String.format("UPDATE %s SET %s=:LAST_CHECK_VALUE WHERE %s=:ID_VALUE", "Links", "dateandtime", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("LAST_CHECK_VALUE", "dateandtime");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM Links", updateLinkSql, primaryKeyMap, parametersMap);
    }

    private void updateHarvestHistoryTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of HarvestHistory");
        String getAllHarvestHistorySql = "SELECT * FROM HarvestHistory";
        String updateHarvestHistorySql = String.format("UPDATE %s SET %s=:HARVEST_DATE_VALUE WHERE %s=:ID_VALUE", "HarvestHistory", "harvestdate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("HARVEST_DATE_VALUE", "harvestdate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, "SELECT * FROM HarvestHistory", updateHarvestHistorySql, primaryKeyMap, parametersMap);
    }

    private void updateMetadataTable(NamedParameterJdbcTemplate jdbcTemplate) {
        LOGGER.info("Updating data of Metadata");
        String getAllMetadataSql = String.format("SELECT %s, %s, %s FROM %s", "id", "changedate", "createdate", "Metadata");
        String updateMetadataSql = String.format("UPDATE %s SET %s=:CHANGE_DATE_VALUE, %s=:CREATE_DATE_VALUE WHERE %s=:ID_VALUE", "Metadata", "changedate", "createdate", "id");
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        parametersMap.put("CHANGE_DATE_VALUE", "changedate");
        parametersMap.put("CREATE_DATE_VALUE", "createdate");
        LinkedHashMap<String, SqlParameter> primaryKeyMap = new LinkedHashMap<String, SqlParameter>();
        primaryKeyMap.put("ID_VALUE", new SqlParameter("id", 4));
        this.processTable(jdbcTemplate, getAllMetadataSql, updateMetadataSql, primaryKeyMap, parametersMap);
    }

    private void processTable(NamedParameterJdbcTemplate jdbcTemplate, String querySql, String updateSql, Map<String, SqlParameter> primaryKey, Map<String, String> timeParameters) {
        Object[] parameters = new Map[50];
        int[] index = new int[]{0};
        RowCallbackHandler rch = arg_0 -> DateTimeMigrationTask.lambda$processTable$0(primaryKey, timeParameters, (Map[])parameters, index, jdbcTemplate, updateSql, arg_0);
        jdbcTemplate.query(querySql, rch);
        if (index[0] != 0) {
            int size = index[0];
            Map[] lastBatchParameters = (Map[])ArrayUtils.subarray((Object[])parameters, (int)0, (int)size);
            jdbcTemplate.batchUpdate(updateSql, lastBatchParameters);
        }
    }

    private static /* synthetic */ void lambda$processTable$0(Map primaryKey, Map timeParameters, Map[] parameters, int[] index, NamedParameterJdbcTemplate jdbcTemplate, String updateSql, ResultSet rs) throws SQLException {
        boolean skipRecord = false;
        try {
            HashMap updateParameters = new HashMap();
            for (Map.Entry entry : primaryKey.entrySet()) {
                int sqlType = ((SqlParameter)entry.getValue()).getSqlType();
                if (sqlType == 4) {
                    updateParameters.put(entry.getKey(), rs.getInt(((SqlParameter)entry.getValue()).getName()));
                    continue;
                }
                if (sqlType == -5) {
                    updateParameters.put(entry.getKey(), rs.getLong(((SqlParameter)entry.getValue()).getName()));
                    continue;
                }
                if (sqlType != 12 && sqlType != -1) continue;
                updateParameters.put(entry.getKey(), rs.getString(((SqlParameter)entry.getValue()).getName()));
            }
            for (Map.Entry entry : timeParameters.entrySet()) {
                String newDbValue;
                String currentDbValue = rs.getString((String)entry.getValue());
                String now = new ISODate().getDateAndTimeUtc();
                String string = newDbValue = StringUtils.isEmpty((String)currentDbValue) ? now : DateUtil.convertToISOZuluDateTime((String)currentDbValue);
                if (newDbValue == null) {
                    newDbValue = now;
                }
                updateParameters.put(entry.getKey(), newDbValue);
            }
            parameters[index[0]] = updateParameters;
        }
        catch (Exception e) {
            LOGGER.error("Error in DateTimeMigrationTask. Problem is: " + e.getMessage());
            LOGGER.error((Throwable)e);
            skipRecord = true;
        }
        if (!skipRecord) {
            if ((index[0] + 1) % 50 == 0) {
                jdbcTemplate.batchUpdate(updateSql, parameters);
                Arrays.fill(parameters, null);
                index[0] = 0;
            } else {
                index[0] = index[0] + 1;
            }
        }
    }
}

