/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.sql.Driver;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.metadata.i18n.Loggings;

public final class JDBC {
    private static final Set<String> DRIVERS = new HashSet<String>();

    private JDBC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecord loadDriver(String driver) {
        LogRecord log = null;
        if (driver != null) {
            Set<String> set = DRIVERS;
            synchronized (set) {
                if (!DRIVERS.contains(driver)) {
                    try {
                        Driver d = (Driver)Class.forName(driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        log = Loggings.format(Level.CONFIG, 26, driver, d.getMajorVersion(), d.getMinorVersion());
                        DRIVERS.add(driver);
                    }
                    catch (Exception exception) {
                        log = new LogRecord(Level.WARNING, exception.toString());
                    }
                }
            }
        }
        return log;
    }
}

