/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;
import org.jclouds.location.Provider;

public class BundleInstanceS3StorageOptions
extends BaseEC2RequestOptions {
    @Inject
    @Provider
    @VisibleForTesting
    Supplier<Credentials> creds;

    public Multimap<String, String> buildFormParameters() {
        if (this.getAwsAccessKeyId() == null) {
            Preconditions.checkState((this.creds != null ? 1 : 0) != 0, (Object)"creds should have been injected");
            this.bucketOwnedBy(((Credentials)this.creds.get()).identity);
        }
        return super.buildFormParameters();
    }

    public BundleInstanceS3StorageOptions bucketOwnedBy(String ccessKeyId) {
        this.formParameters.put((Object)"Storage.S3.AWSAccessKeyId", Preconditions.checkNotNull((Object)ccessKeyId, (Object)"ccessKeyId"));
        return this;
    }

    public String getAwsAccessKeyId() {
        return this.getFirstFormOrNull("Storage.S3.AWSAccessKeyId");
    }

    public static class Builder {
        public static BundleInstanceS3StorageOptions bucketOwnedBy(String accessKeyId) {
            BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
            return options.bucketOwnedBy(accessKeyId);
        }
    }
}

