/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.dataformat.UniVocityAbstractDataFormat;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.15.0", label="dataformat,transformation,csv", title="uniVocity CSV")
@XmlRootElement(name="univocity-csv")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UniVocityCsvDataFormat
extends UniVocityAbstractDataFormat {
    @XmlAttribute
    private Boolean quoteAllFields;
    @XmlAttribute
    @Metadata(defaultValue="\"")
    private String quote;
    @XmlAttribute
    @Metadata(defaultValue="\"")
    private String quoteEscape;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;

    public UniVocityCsvDataFormat() {
        super("univocity-csv");
    }

    public Boolean getQuoteAllFields() {
        return this.quoteAllFields;
    }

    public void setQuoteAllFields(Boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public String getQuoteEscape() {
        return this.quoteEscape;
    }

    public void setQuoteEscape(String quoteEscape) {
        this.quoteEscape = quoteEscape;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        super.configureDataFormat(dataFormat, camelContext);
        if (this.quoteAllFields != null) {
            this.setProperty(camelContext, dataFormat, "quoteAllFields", this.quoteAllFields);
        }
        if (this.quote != null) {
            this.setProperty(camelContext, dataFormat, "quote", UniVocityCsvDataFormat.singleCharOf("quote", this.quote));
        }
        if (this.quoteEscape != null) {
            this.setProperty(camelContext, dataFormat, "quoteEscape", UniVocityCsvDataFormat.singleCharOf("quoteEscape", this.quoteEscape));
        }
        if (this.delimiter != null) {
            this.setProperty(camelContext, dataFormat, "delimiter", UniVocityCsvDataFormat.singleCharOf("delimiter", this.delimiter));
        }
    }
}

