/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileConfiguration
extends BaseConfiguration
implements FileConfiguration {
    public static final int EVENT_RELOAD = 20;
    protected String fileName;
    protected String basePath;
    protected boolean autoSave;
    protected ReloadingStrategy strategy;
    private Object reloadLock = new Object();
    private String encoding;
    private URL sourceURL;
    private int noReload;

    public AbstractFileConfiguration() {
        this.initReloadingStrategy();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public AbstractFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
        this.load();
    }

    public AbstractFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public void load() throws ConfigurationException {
        if (this.sourceURL != null) {
            this.load(this.sourceURL);
        } else {
            this.load(this.getFileName());
        }
    }

    public void load(String fileName) throws ConfigurationException {
        try {
            URL url = ConfigurationUtils.locate(this.basePath, fileName);
            if (url == null) {
                throw new ConfigurationException("Cannot locate configuration source " + fileName);
            }
            this.load(url);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void load(File file) throws ConfigurationException {
        try {
            this.load(file.toURL());
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    public void load(URL url) throws ConfigurationException {
        block13: {
            File file;
            if (this.sourceURL == null) {
                if (StringUtils.isEmpty((String)this.getBasePath())) {
                    this.setBasePath(url.toString());
                }
                this.sourceURL = url;
            }
            if ((file = ConfigurationUtils.fileFromURL(url)) != null && file.isDirectory()) {
                throw new ConfigurationException("Cannot load a configuration from a directory");
            }
            InputStream in = null;
            in = url.openStream();
            this.load(in);
            Object var7_4 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block13;
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"Could not close input stream", (Throwable)e);
            }
            break block13;
            {
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    this.getLogger().warn((Object)"Could not close input stream", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(in, this.getEncoding());
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        InputStreamReader reader = null;
        if (encoding != null) {
            try {
                reader = new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(in);
        }
        this.load(reader);
    }

    public void save() throws ConfigurationException {
        if (this.getFileName() == null) {
            throw new ConfigurationException("No file name has been set!");
        }
        if (this.sourceURL != null) {
            this.save(this.sourceURL);
        } else {
            this.save(this.fileName);
        }
        this.strategy.init();
    }

    public void save(String fileName) throws ConfigurationException {
        try {
            File file = ConfigurationUtils.getFile(this.basePath, fileName);
            if (file == null) {
                throw new ConfigurationException("Invalid file name for save: " + fileName);
            }
            this.save(file);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save(URL url) throws ConfigurationException {
        File file = ConfigurationUtils.fileFromURL(url);
        if (file != null) {
            this.save(file);
        } else {
            OutputStream out = null;
            try {
                try {
                    HttpURLConnection conn;
                    URLConnection connection = url.openConnection();
                    connection.setDoOutput(true);
                    if (connection instanceof HttpURLConnection) {
                        conn = (HttpURLConnection)connection;
                        conn.setRequestMethod("PUT");
                    }
                    out = connection.getOutputStream();
                    this.save(out);
                    if (connection instanceof HttpURLConnection && (conn = (HttpURLConnection)connection).getResponseCode() >= 400) {
                        throw new IOException("HTTP Error " + conn.getResponseCode() + " " + conn.getResponseMessage());
                    }
                    Object var7_7 = null;
                    this.closeSilent(out);
                }
                catch (IOException e) {
                    throw new ConfigurationException("Could not save to URL " + url, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeSilent(out);
                throw throwable;
            }
        }
    }

    public void save(File file) throws ConfigurationException {
        FileOutputStream out = null;
        try {
            try {
                this.createPath(file);
                out = new FileOutputStream(file);
                this.save(out);
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            Object var5_3 = null;
            this.closeSilent(out);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.closeSilent(out);
            throw throwable;
        }
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.save(out, this.getEncoding());
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        OutputStreamWriter writer = null;
        if (encoding != null) {
            try {
                writer = new OutputStreamWriter(out, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(out);
        }
        this.save(writer);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.sourceURL = null;
        this.fileName = fileName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.sourceURL = null;
        this.basePath = basePath;
    }

    public File getFile() {
        if (this.getFileName() == null && this.sourceURL == null) {
            return null;
        }
        if (this.sourceURL != null) {
            return ConfigurationUtils.fileFromURL(this.sourceURL);
        }
        return ConfigurationUtils.getFile(this.getBasePath(), this.getFileName());
    }

    public void setFile(File file) {
        this.sourceURL = null;
        this.setFileName(file.getName());
        this.setBasePath(file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : null);
    }

    public String getPath() {
        String path = null;
        File file = this.getFile();
        if (file != null) {
            path = file.getAbsolutePath();
        }
        if (path == null) {
            if (this.sourceURL != null) {
                path = this.sourceURL.getPath();
            } else {
                try {
                    path = ConfigurationUtils.getURL(this.getBasePath(), this.getFileName()).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return path;
    }

    public void setPath(String path) {
        this.setFile(new File(path));
    }

    public URL getURL() {
        return this.sourceURL != null ? this.sourceURL : ConfigurationUtils.locate(this.getBasePath(), this.getFileName());
    }

    public void setURL(URL url) {
        this.setBasePath(ConfigurationUtils.getBasePath(url));
        this.setFileName(ConfigurationUtils.getFileName(url));
        this.sourceURL = url;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    protected void possiblySave() {
        if (this.autoSave && this.fileName != null) {
            try {
                this.save();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationRuntimeException("Failed to auto-save", (Throwable)((Object)e));
            }
        }
    }

    public void addProperty(String key, Object value) {
        super.addProperty(key, value);
        this.possiblySave();
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        this.possiblySave();
    }

    public void clearProperty(String key) {
        super.clearProperty(key);
        this.possiblySave();
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.strategy;
    }

    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.strategy = strategy;
        strategy.setConfiguration(this);
        strategy.init();
    }

    public void reload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload == 0) {
                try {
                    block11: {
                        try {
                            this.enterNoReload();
                            if (!this.strategy.reloadingRequired()) break block11;
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info((Object)("Reloading configuration. URL is " + this.getURL()));
                            }
                            this.fireEvent(20, null, this.getURL(), true);
                            this.setDetailEvents(false);
                            boolean autoSaveBak = this.isAutoSave();
                            this.setAutoSave(false);
                            try {
                                this.clear();
                                this.load();
                                Object var4_4 = null;
                                this.setAutoSave(autoSaveBak);
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                this.setAutoSave(autoSaveBak);
                                this.setDetailEvents(true);
                                throw throwable;
                            }
                            this.setDetailEvents(true);
                            this.fireEvent(20, null, this.getURL(), false);
                            this.strategy.reloadingPerformed();
                        }
                        catch (Exception e) {
                            this.fireError(20, null, null, e);
                            Object var6_8 = null;
                            this.exitNoReload();
                        }
                    }
                    Object var6_7 = null;
                    this.exitNoReload();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.exitNoReload();
                    throw throwable;
                }
            }
        }
    }

    protected void enterNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            ++this.noReload;
        }
    }

    protected void exitNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload > 0) {
                --this.noReload;
            }
        }
    }

    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        this.enterNoReload();
        try {
            super.fireEvent(type, propName, propValue, before);
            Object var6_5 = null;
            this.exitNoReload();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.exitNoReload();
            throw throwable;
        }
    }

    public Object getProperty(String key) {
        this.reload();
        return super.getProperty(key);
    }

    public boolean isEmpty() {
        this.reload();
        return super.isEmpty();
    }

    public boolean containsKey(String key) {
        this.reload();
        return super.containsKey(key);
    }

    public Iterator getKeys() {
        this.reload();
        return super.getKeys();
    }

    private void createPath(File file) {
        File parent;
        if (file != null && !file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Object clone() {
        AbstractFileConfiguration copy = (AbstractFileConfiguration)super.clone();
        copy.setBasePath(null);
        copy.setFileName(null);
        copy.initReloadingStrategy();
        return copy;
    }

    private void initReloadingStrategy() {
        this.setReloadingStrategy(new InvariantReloadingStrategy());
    }

    private void closeSilent(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn((Object)"Could not close output stream", (Throwable)e);
        }
    }

    public abstract void save(Writer var1) throws ConfigurationException;

    public abstract void load(Reader var1) throws ConfigurationException;
}

