/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.sesame.sailimpl.rdbms.MySQL;
import org.openrdf.sesame.sailimpl.rdbms.Oracle;
import org.openrdf.sesame.sailimpl.rdbms.PostgreSQL;
import org.openrdf.sesame.sailimpl.rdbms.SQLServer;
import org.openrdf.util.StringUtil;
import org.openrdf.util.jdbc.ConnectionPool;
import org.openrdf.util.log.ThreadLog;

public class RDBMS {
    protected boolean _supportsLikeEscapeClause = false;
    protected String _searchStringEscape = null;
    public String ID_INT = "integer";
    public int ID_INT_TYPE = 4;
    public String LOCALNAME = "character varying(255)";
    public int LOCALNAME_TYPE = 12;
    public String LANGUAGE = "character varying(16)";
    public int LANGUAGE_TYPE = 12;
    public String LABEL = "clob";
    public int LABEL_TYPE = 2005;
    public String LABEL_HASH = "bigint";
    public int LABEL_HASH_TYPE = -5;
    public String PREFIX = "character varying(16)";
    public int PREFIX_TYPE = 12;
    public int MAX_PREFIX_LENGTH = 16;
    public String NAME = "clob";
    public int NAME_TYPE = 2005;
    public String BOOLEAN = "boolean";
    public int BOOLEAN_TYPE = 16;
    public String TRUE = "TRUE";
    public String FALSE = "FALSE";
    public String INFOFIELD = "character varying(255)";
    public int INFOFIELD_TYPE = 12;
    protected ConnectionPool _conPool;
    protected Map _tableRowCounts = new HashMap(32);
    protected Map _tableModRowCounts = new HashMap(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDBMS createInstance(String jdbcUrl, String user, String passwd) throws SQLException {
        String dbName = null;
        String dbVersion = null;
        try {
            Connection con = user == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, user, passwd);
            try {
                DatabaseMetaData metaData = con.getMetaData();
                dbName = metaData.getDatabaseProductName();
                dbVersion = metaData.getDatabaseProductVersion();
            }
            finally {
                con.close();
            }
        }
        catch (SQLException e) {
            ThreadLog.warning((String)"Failed to get database parameters", (Object)e);
        }
        if (dbName != null) {
            ThreadLog.log((String)("Detected database: " + dbName));
            if (dbVersion != null) {
                ThreadLog.log((String)("Database version: " + dbVersion));
            }
        }
        RDBMS result = "MySQL".equalsIgnoreCase(dbName) ? new MySQL() : ("PostgreSQL".equalsIgnoreCase(dbName) ? new PostgreSQL() : ("Oracle".equalsIgnoreCase(dbName) ? new Oracle() : ("Microsoft SQL Server".equalsIgnoreCase(dbName) ? new SQLServer() : new RDBMS())));
        result.setConnectionInfo(jdbcUrl, user, passwd);
        return result;
    }

    public void setConnectionInfo(String jdbcUrl, String user, String password) throws SQLException {
        this.disconnect();
        this._createConnectionPool(jdbcUrl, user, password);
        Connection con = this.getConnection();
        DatabaseMetaData metaData = con.getMetaData();
        this._initConstants(metaData);
        con.close();
    }

    protected void _createConnectionPool(String jdbcUrl, String user, String passwd) {
        this._conPool = new ConnectionPool(jdbcUrl, user, passwd);
        this._conPool.setCheckConnections(false);
        this._conPool.setMaxUseTime(3600000L);
    }

    protected void _initConstants(DatabaseMetaData metaData) throws SQLException {
        this._supportsLikeEscapeClause = metaData.supportsLikeEscapeClause();
        ThreadLog.trace((String)("RDBMS supports like escape-clause: " + this._supportsLikeEscapeClause));
        this._searchStringEscape = metaData.getSearchStringEscape();
        if (this._searchStringEscape != null && this._searchStringEscape.length() == 0) {
            this._searchStringEscape = null;
        }
        ThreadLog.trace((String)("RDBMS search string escape: " + this._searchStringEscape));
    }

    public void disconnect() {
        if (this._conPool != null) {
            this._conPool.drain();
        }
    }

    public Connection getConnection() throws SQLException {
        return this._conPool.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String query) throws SQLException {
        Connection con = this.getConnection();
        try {
            int n;
            Statement st = con.createStatement();
            try {
                n = st.executeUpdate(query);
            }
            catch (Throwable throwable) {
                st.close();
                throw throwable;
            }
            st.close();
            return n;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryHasResults(String query) throws SQLException {
        Connection con = this.getConnection();
        try {
            boolean bl;
            Statement st = con.createStatement();
            try {
                ResultSet rs = st.executeQuery(query);
                boolean result = rs.next();
                rs.close();
                bl = result;
            }
            catch (Throwable throwable) {
                st.close();
                throw throwable;
            }
            st.close();
            return bl;
        }
        finally {
            con.close();
        }
    }

    public void createIndex(String table, String column) throws SQLException {
        this.createIndex(table, new String[]{column}, false);
    }

    public void createUniqueIndex(String table, String column) throws SQLException {
        this.createIndex(table, new String[]{column}, true);
    }

    public void createIndex(String table, String[] columns, boolean unique) throws SQLException {
        if (columns.length == 0) {
            throw new IllegalArgumentException("columns must contain at least one column name");
        }
        StringBuffer query = new StringBuffer(64);
        query.append("CREATE ");
        if (unique) {
            query.append("UNIQUE ");
        }
        query.append("INDEX ").append(this.getIndexName(table, columns));
        query.append(" ON ").append(table);
        query.append(" (").append(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            query.append(", ").append(columns[i]);
        }
        query.append(")");
        this.executeUpdate(query.toString());
    }

    public void dropIndex(String table, String column) throws SQLException {
        this.dropIndex(table, new String[]{column});
    }

    public void dropIndex(String table, String[] columns) throws SQLException {
        this.executeUpdate("DROP INDEX " + this.getIndexName(table, columns));
    }

    public String getIndexName(String table, String column) {
        return this.getIndexName(table, new String[]{column});
    }

    public String getIndexName(String table, String[] columns) {
        StringBuffer name = new StringBuffer(32);
        name.append(table).append("_").append(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            name.append("_").append(columns[i]);
        }
        name.append("_idx");
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists(String tableName) throws SQLException {
        boolean tableExists = false;
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            try {
                ResultSet rs = st.executeQuery("select count(*) from " + tableName);
                tableExists = rs.next();
                rs.close();
                return tableExists;
            }
            catch (SQLException e) {
                return tableExists;
            }
            finally {
                st.close();
            }
        }
        finally {
            con.close();
        }
    }

    public void optimizeTable(String tableName, int modifiedRowsCount) throws SQLException {
        int modRowCount;
        if (modifiedRowsCount <= 0) {
            return;
        }
        Integer i = (Integer)this._tableRowCounts.get(tableName);
        int rowCount = i == null ? this._getRowCount(tableName) : i.intValue();
        i = (Integer)this._tableModRowCounts.get(tableName);
        int n = modRowCount = i == null ? 0 : i;
        if ((modRowCount += modifiedRowsCount) > 10000 || rowCount / modRowCount <= 2) {
            this.optimizeTable(tableName);
            rowCount = this._getRowCount(tableName);
            modRowCount = 0;
        }
        this._tableRowCounts.put(tableName, new Integer(rowCount));
        this._tableModRowCounts.put(tableName, new Integer(modRowCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getRowCount(String tableName) throws SQLException {
        Connection con = this.getConnection();
        try {
            int n;
            Statement st = con.createStatement();
            try {
                ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM " + tableName);
                rs.next();
                int result = rs.getInt(1);
                rs.close();
                n = result;
            }
            catch (Throwable throwable) {
                st.close();
                throw throwable;
            }
            st.close();
            return n;
        }
        finally {
            con.close();
        }
    }

    public void optimizeTable(String tableName) throws SQLException {
    }

    public final void clearTable(String tableName) throws SQLException {
        this._clearTable(tableName);
        this._tableRowCounts.put(tableName, new Integer(0));
        this._tableModRowCounts.put(tableName, new Integer(0));
    }

    protected void _clearTable(String tableName) throws SQLException {
        this.executeUpdate("DELETE FROM " + tableName);
    }

    public final void dropTable(String tableName) throws SQLException {
        this._dropTable(tableName);
        this._tableRowCounts.remove(tableName);
        this._tableModRowCounts.remove(tableName);
    }

    protected void _dropTable(String tableName) throws SQLException {
        this.executeUpdate("DROP TABLE " + tableName);
    }

    public final void renameTable(String currentTableName, String newTableName) throws SQLException {
        Integer modRowCount;
        this._renameTable(currentTableName, newTableName);
        Integer rowCount = (Integer)this._tableRowCounts.remove(currentTableName);
        if (rowCount != null) {
            this._tableRowCounts.put(newTableName, rowCount);
        }
        if ((modRowCount = (Integer)this._tableModRowCounts.remove(currentTableName)) != null) {
            this._tableModRowCounts.put(newTableName, modRowCount);
        }
    }

    protected void _renameTable(String currentTableName, String newTableName) throws SQLException {
        this.executeUpdate("ALTER TABLE " + currentTableName + " RENAME TO " + newTableName);
    }

    public void renameTableColumn(String tableName, String currentColumnName, String newColumnName, String columnSignature) throws SQLException {
        this.executeUpdate("ALTER TABLE " + tableName + " RENAME COLUMN " + currentColumnName + " TO " + newColumnName);
    }

    public int copyRows(String sourceTable, String targetTable) throws SQLException {
        return this.executeUpdate("INSERT INTO " + targetTable + " SELECT * FROM " + sourceTable);
    }

    public int copyDistinctRows(String sourceTable, String targetTable) throws SQLException {
        return this.executeUpdate("INSERT INTO " + targetTable + " SELECT DISTINCT * FROM " + sourceTable);
    }

    public String convertBoolean(boolean b) {
        return b ? this.TRUE : this.FALSE;
    }

    public String escapeString(String s) {
        String result = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        result = StringUtil.gsub((String)"'", (String)"\\'", (String)result);
        return result;
    }

    public boolean emptyStringIsNull() {
        return false;
    }

    public boolean supportsPatternMatches(boolean caseSensitive) {
        return false;
    }

    public String getPatternMatchOperator(boolean caseSensitive) {
        throw new UnsupportedOperationException();
    }

    public String getPatternMatchExpr(String pattern, boolean caseSensitive) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLikeEscapeClause() {
        return this._supportsLikeEscapeClause;
    }

    public String getSearchStringEscape() {
        return this._searchStringEscape;
    }
}

