/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.springframework.util.StringUtils;

public class KeycloakConfiguration
implements SecurityProviderConfiguration {
    public static final String REDIRECT_PLACEHOLDER = "{RedirecUrl}";
    private final String SECURITY_PROVIDER = "KEYCLOAK";
    private String DEFAULT_ROLE_GROUP_SEPARATOR = ":";
    private String loginType;
    private String publicClientId;
    private String organisationKey;
    private String IDPLogoutUrl;
    private boolean updateProfile;
    private boolean updateGroup;
    private String roleGroupSeparator;

    public String getIDPLogoutUrl() {
        return this.IDPLogoutUrl;
    }

    public void setIDPLogoutUrl(String IDPLogoutUrl) {
        if (IDPLogoutUrl != null && !IDPLogoutUrl.contains(REDIRECT_PLACEHOLDER)) {
            throw new BadParameterEx("IDPLogoutUrl", (Object)IDPLogoutUrl);
        }
        this.IDPLogoutUrl = IDPLogoutUrl;
    }

    public String getOrganisationKey() {
        return this.organisationKey;
    }

    public void setOrganisationKey(String organisationKey) {
        this.organisationKey = organisationKey;
    }

    public boolean isUpdateProfile() {
        return this.updateProfile;
    }

    public void setUpdateProfile(boolean updateProfile) {
        this.updateProfile = updateProfile;
    }

    public boolean isUpdateGroup() {
        return this.updateGroup;
    }

    public void setUpdateGroup(boolean updateGroup) {
        this.updateGroup = updateGroup;
    }

    public String getPublicClientId() {
        return this.publicClientId;
    }

    public void setPublicClientId(String publicClientId) {
        this.publicClientId = publicClientId;
    }

    public String getRoleGroupSeparator() {
        return this.roleGroupSeparator;
    }

    public void setRoleGroupSeparator(String roleGroupSeparator) {
        if (StringUtils.isEmpty((Object)roleGroupSeparator)) {
            roleGroupSeparator = this.DEFAULT_ROLE_GROUP_SEPARATOR;
        }
        this.roleGroupSeparator = roleGroupSeparator;
    }

    @Override
    public String getSecurityProvider() {
        return "KEYCLOAK";
    }

    @Override
    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        SecurityProviderConfiguration.LoginType parsedLoginType = SecurityProviderConfiguration.LoginType.parse(loginType);
        switch (parsedLoginType) {
            case LINK: 
            case AUTOLOGIN: {
                break;
            }
            case DEFAULT: {
                parsedLoginType = SecurityProviderConfiguration.LoginType.LINK;
                break;
            }
            default: {
                throw new BadParameterEx("loginType", (Object)parsedLoginType.toString());
            }
        }
        this.loginType = parsedLoginType.toString();
    }

    @Override
    public boolean isUserProfileUpdateEnabled() {
        return !this.updateProfile;
    }

    @Override
    public boolean isUserGroupUpdateEnabled() {
        return !this.updateGroup;
    }
}

