/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.jdom.Content;
import org.jdom.Element;

public class Lib {
    public static final String SESSION_OBJECT = "oai-list-records-result";
    private static ServiceConfig dummyConfig = new ServiceConfig();

    public static boolean existsConverter(Path schemaDir, String prefix) {
        Path f = schemaDir.resolve("convert").resolve(prefix + ".xsl");
        return Files.exists(f, new LinkOption[0]);
    }

    public static Element prepareTransformEnv(String uuid, String changeDate, String baseUrl, String siteUrl, String siteName) {
        Element env = new Element("env");
        env.addContent((Content)new Element("uuid").setText(uuid));
        env.addContent((Content)new Element("changeDate").setText(changeDate));
        env.addContent((Content)new Element("baseURL").setText(baseUrl));
        env.addContent((Content)new Element("siteURL").setText(siteUrl));
        env.addContent((Content)new Element("siteName").setText(siteName));
        return env;
    }

    public static Element transform(Path schemaDir, Element env, Element md, String targetFormat) throws Exception {
        Element root = new Element("root");
        root.addContent((Content)md);
        root.addContent((Content)env);
        Path styleSheet = schemaDir.resolve("convert").resolve(targetFormat);
        return Xml.transform((Element)root, (Path)styleSheet);
    }

    public static List<Integer> search(ServiceContext context, Element params) throws Exception {
        throw new UnsupportedOperationException("ES search does not support OAI yet");
    }

    public static Element toJeevesException(OaiPmhException e) {
        String msg = e.getMessage();
        String cls = e.getClass().getSimpleName();
        String id = e.getCode();
        Element res = e.getResponse();
        Element error = new Element("error").addContent((Content)new Element("message").setText(msg)).addContent((Content)new Element("class").setText(cls));
        error.setAttribute("id", id);
        if (res != null) {
            Element elObj = new Element("object");
            elObj.addContent(res.detach());
            error.addContent((Content)elObj);
        }
        return error;
    }
}

