/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.gogrid.compute.functions.OptionToLocation;
import org.jclouds.gogrid.compute.functions.ServerImageToImage;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.options.GoGridTemplateOptions;
import org.jclouds.gogrid.compute.strategy.GoGridComputeServiceAdapter;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerState;

public class GoGridComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Hardware, ServerImage, Option> {
    @VisibleForTesting
    static final Map<ServerState, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)ServerState.ON, (Object)NodeMetadata.Status.RUNNING).put((Object)ServerState.STARTING, (Object)NodeMetadata.Status.PENDING).put((Object)ServerState.OFF, (Object)NodeMetadata.Status.SUSPENDED).put((Object)ServerState.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)ServerState.RESTARTING, (Object)NodeMetadata.Status.PENDING).put((Object)ServerState.SAVING, (Object)NodeMetadata.Status.PENDING).put((Object)ServerState.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)ServerState.RESTORING, (Object)NodeMetadata.Status.PENDING).put((Object)ServerState.UPDATING, (Object)NodeMetadata.Status.PENDING).build();
    @VisibleForTesting
    static final Map<ServerImageState, Image.Status> toPortableImageStatus = ImmutableMap.builder().put((Object)ServerImageState.AVAILABLE, (Object)Image.Status.AVAILABLE).put((Object)ServerImageState.SAVING, (Object)Image.Status.PENDING).put((Object)ServerImageState.TRASH, (Object)Image.Status.DELETED).put((Object)ServerImageState.UNRECOGNIZED, (Object)Image.Status.UNRECOGNIZED).build();

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Server, Hardware, ServerImage, Option>>(){}).to(GoGridComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerImage, Image>>(){}).to(ServerImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Option, Location>>(){}).to(OptionToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(TemplateOptions.class).to(GoGridTemplateOptions.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Server, Hardware, ServerImage, Option>(){});
    }

    @Singleton
    @Provides
    final Map<ServerState, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    final Map<ServerImageState, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @Singleton
    @Provides
    final Function<Hardware, String> provideSizeToRam() {
        return new Function<Hardware, String>(){

            public String apply(Hardware hardware) {
                if (hardware.getRam() >= 8192 || ComputeServiceUtils.getCores((Hardware)hardware) >= 6.0 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 450.0) {
                    return "8GB";
                }
                if (hardware.getRam() >= 4096 || ComputeServiceUtils.getCores((Hardware)hardware) >= 3.0 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 230.0) {
                    return "4GB";
                }
                if (hardware.getRam() >= 2048 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 110.0) {
                    return "2GB";
                }
                if (hardware.getRam() >= 1024 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 55.0) {
                    return "1GB";
                }
                return "512MB";
            }
        };
    }
}

