/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class ParseAlgorithms
implements Function<HttpResponse, List<String>>,
InvocationContext<ParseAlgorithms> {
    private final ParseJson<Map<String, List<Map<String, String>>>> json;

    @Inject
    ParseAlgorithms(ParseJson<Map<String, List<Map<String, String>>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public List<String> apply(HttpResponse response) {
        Map map = (Map)this.json.apply(response);
        if (map == null || map.isEmpty()) {
            throw new HttpResponseException("Unexpected JSON format returned.", null, response);
        }
        List list = (List)Iterables.get(map.values(), (int)0);
        ArrayList algorithms = Lists.newArrayList();
        for (Map nameAlgorithmPair : list) {
            algorithms.add(Iterables.get(nameAlgorithmPair.values(), (int)0));
        }
        return algorithms;
    }

    public ParseAlgorithms setContext(HttpRequest request) {
        return this;
    }
}

