/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.server;

import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.fao.oaipmh.exceptions.BadVerbException;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.requests.GetRecordRequest;
import org.fao.oaipmh.requests.IdentifyRequest;
import org.fao.oaipmh.requests.ListIdentifiersRequest;
import org.fao.oaipmh.requests.ListMetadataFormatsRequest;
import org.fao.oaipmh.requests.ListRecordsRequest;
import org.fao.oaipmh.requests.ListSetsRequest;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OaiPmhFactory {
    public static Map<String, String> extractParams(Element request) throws BadArgumentException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object o : request.getChildren()) {
            Element elem = (Element)o;
            String name = elem.getName();
            String value = elem.getText();
            if (params.containsKey(name)) {
                throw new BadArgumentException("Parameter repeated : " + name);
            }
            params.put(name, value);
        }
        return params;
    }

    public static AbstractRequest parse(ConfigurableApplicationContext applicationContext, Map<String, String> params) throws BadVerbException, BadArgumentException {
        HashMap<String, String> params2 = new HashMap<String, String>();
        for (Map.Entry<String, String> param : params.entrySet()) {
            params2.put(param.getKey(), param.getValue());
        }
        params = params2;
        String verb = OaiPmhFactory.consumeMan(params, "verb");
        if (verb.equals("Identify")) {
            return OaiPmhFactory.handleIdentify((ApplicationContext)applicationContext, params);
        }
        if (verb.equals("GetRecord")) {
            return OaiPmhFactory.handleGetRecord((ApplicationContext)applicationContext, params);
        }
        if (verb.equals("ListIdentifiers")) {
            return OaiPmhFactory.handleListIdentifiers((ApplicationContext)applicationContext, params);
        }
        if (verb.equals("ListMetadataFormats")) {
            return OaiPmhFactory.handleListMdFormats((ApplicationContext)applicationContext, params);
        }
        if (verb.equals("ListRecords")) {
            return OaiPmhFactory.handleListRecords((ApplicationContext)applicationContext, params);
        }
        if (verb.equals("ListSets")) {
            return OaiPmhFactory.handleListSets((ApplicationContext)applicationContext, params);
        }
        throw new BadVerbException("Unknown verb : " + verb);
    }

    private static String consumeMan(Map<String, String> params, String name) throws BadArgumentException {
        String value = params.get(name);
        if (value == null) {
            throw new BadArgumentException("Missing '" + name + "' parameter");
        }
        if (value.trim().length() == 0) {
            throw new BadArgumentException("Empty '" + name + "' parameter");
        }
        params.remove(name);
        return value;
    }

    private static String consumeOpt(Map<String, String> params, String name) throws BadArgumentException {
        String value = params.get(name);
        if (value == null) {
            return null;
        }
        if (value.trim().length() == 0) {
            throw new BadArgumentException("Empty '" + name + "' parameter");
        }
        params.remove(name);
        return value;
    }

    private static ISODate consumeDate(Map<String, String> params, String name) throws BadArgumentException {
        String date = OaiPmhFactory.consumeOpt(params, name);
        if (date == null) {
            return null;
        }
        try {
            return new ISODate(date);
        }
        catch (Exception e) {
            throw new BadArgumentException("Illegal date format : " + date);
        }
    }

    private static void checkConsumption(Map<String, String> params) throws BadArgumentException {
        if (params.keySet().size() == 0) {
            return;
        }
        String extraParam = params.keySet().iterator().next();
        throw new BadArgumentException("Unknown extra parameter '" + extraParam + "'");
    }

    private static IdentifyRequest handleIdentify(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        OaiPmhFactory.checkConsumption(params);
        return new IdentifyRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
    }

    private static GetRecordRequest handleGetRecord(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        GetRecordRequest req = new GetRecordRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
        req.setIdentifier(OaiPmhFactory.consumeMan(params, "identifier"));
        req.setMetadataPrefix(OaiPmhFactory.consumeMan(params, "metadataPrefix"));
        OaiPmhFactory.checkConsumption(params);
        return req;
    }

    private static ListIdentifiersRequest handleListIdentifiers(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        ListIdentifiersRequest req = new ListIdentifiersRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
        if (params.containsKey("resumptionToken")) {
            req.setResumptionToken(OaiPmhFactory.consumeMan(params, "resumptionToken"));
        } else {
            req.setMetadataPrefix(OaiPmhFactory.consumeMan(params, "metadataPrefix"));
            req.setSet(OaiPmhFactory.consumeOpt(params, "set"));
            req.setFrom(OaiPmhFactory.consumeDate(params, "from"));
            req.setUntil(OaiPmhFactory.consumeDate(params, "until"));
        }
        OaiPmhFactory.checkConsumption(params);
        return req;
    }

    private static ListMetadataFormatsRequest handleListMdFormats(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        ListMetadataFormatsRequest req = new ListMetadataFormatsRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
        req.setIdentifier(OaiPmhFactory.consumeOpt(params, "identifier"));
        OaiPmhFactory.checkConsumption(params);
        return req;
    }

    private static ListRecordsRequest handleListRecords(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        ListRecordsRequest req = new ListRecordsRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
        if (params.containsKey("resumptionToken")) {
            req.setResumptionToken(OaiPmhFactory.consumeMan(params, "resumptionToken"));
        } else {
            req.setMetadataPrefix(OaiPmhFactory.consumeMan(params, "metadataPrefix"));
            req.setSet(OaiPmhFactory.consumeOpt(params, "set"));
            req.setFrom(OaiPmhFactory.consumeDate(params, "from"));
            req.setUntil(OaiPmhFactory.consumeDate(params, "until"));
        }
        OaiPmhFactory.checkConsumption(params);
        return req;
    }

    private static ListSetsRequest handleListSets(ApplicationContext applicationContext, Map<String, String> params) throws BadArgumentException {
        ListSetsRequest req = new ListSetsRequest((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class));
        if (params.containsKey("resumptionToken")) {
            req.setResumptionToken(OaiPmhFactory.consumeMan(params, "resumptionToken"));
        }
        OaiPmhFactory.checkConsumption(params);
        return req;
    }
}

