/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.css.Less4jProcessor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public class GeonetLessCompilerProcessor
extends Less4jProcessor {
    public static final String ALIAS = "geonetLessCompiler";
    private static final String LESS_EXT = ".less";
    private static final Logger LOG = Logger.getLogger(GeonetLessCompilerProcessor.class.getPackage().getName());
    @Inject
    private UriLocatorFactory locatorFactory;
    private final LessCompiler compiler = new DefaultLessCompiler();

    public void process(Reader reader, Writer writer) throws IOException {
        try {
            this.process(null, reader, writer);
        }
        catch (Throwable t) {
            LOG.fine("Unable to compile a stylesheet");
        }
    }

    private Path openFileWithCustomStyle(String path) throws IOException {
        Path lessPath = Paths.get(path + "/gn_dynamic_style.json", new String[0]);
        if (Files.exists(lessPath, new LinkOption[0])) {
            return lessPath;
        }
        return null;
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        if (resource.getUri().endsWith(LESS_EXT)) {
            try {
                String customLessVariables = this.getCustomLessVariables();
                String stringReader = IOUtils.toString((Reader)reader) + customLessVariables;
                RelativeAwareLessSource lessSource = new RelativeAwareLessSource(resource, stringReader, this.locatorFactory);
                LessCompiler.CompilationResult result = this.compiler.compile((LessSource)lessSource);
                this.logWarnings(result);
                writer.write(result.getCss());
            }
            catch (Less4jException e) {
                LOG.fine("Failed to compile less resource: {}.");
                for (LessCompiler.Problem problem : e.getErrors()) {
                    LOG.fine(this.problemAsString(problem));
                }
                throw WroRuntimeException.wrap((Exception)((Object)e));
            }
            catch (Exception e) {
                LOG.fine("Exception while compiling less resource: {}.");
                throw WroRuntimeException.wrap((Exception)e);
            }
        } else {
            writer.write(IOUtils.toString((Reader)reader));
        }
    }

    private String getCustomLessVariables() throws IOException {
        Path customLessFile = this.getCustomLessFile();
        return this.readCustomLessFile(customLessFile);
    }

    private String readCustomLessFile(Path customLessFile) throws IOException {
        String customLessVariables = new String();
        if (customLessFile != null) {
            String content = new String(Files.readAllBytes(customLessFile));
            try {
                JSONObject jObject = new JSONObject(content);
                Iterator iter = jObject.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (jObject.getString(key) == null || jObject.getString(key).trim().equals("")) continue;
                    customLessVariables = customLessVariables + "\n @" + key.trim() + " : " + jObject.getString(key).trim() + ";";
                }
            }
            catch (JSONException e) {
                throw WroRuntimeException.wrap((Exception)((Object)e));
            }
        }
        return customLessVariables;
    }

    private Path getCustomLessFile() throws IOException {
        try {
            GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
            if (geonetworkDataDirectory != null && geonetworkDataDirectory.getSystemDataDir() != null) {
                String path = geonetworkDataDirectory.getSystemDataDir().resolve("node_less_files").toString();
                Path customLessFile = this.openFileWithCustomStyle(path);
                return customLessFile;
            }
            return null;
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.fine("org.fao.geonet.kernel.GeonetworkDataDirectory bean not found");
            return null;
        }
    }

    private void logWarnings(LessCompiler.CompilationResult result) {
        if (!result.getWarnings().isEmpty()) {
            LOG.fine("Less warnings are:");
            for (LessCompiler.Problem problem : result.getWarnings()) {
                LOG.fine(this.problemAsString(problem));
            }
        }
    }

    private String problemAsString(LessCompiler.Problem problem) {
        return String.format("%s:%s %s.", problem.getLine(), problem.getCharacter(), problem.getMessage());
    }

    private static class RelativeAwareLessSource
    extends LessSource.StringSource {
        private final Resource resource;
        private final UriLocatorFactory locatorFactory;

        public RelativeAwareLessSource(Resource resource, String content, UriLocatorFactory locatorFactory) {
            super(content);
            this.resource = resource;
            Validate.notNull((Object)locatorFactory);
            this.locatorFactory = locatorFactory;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.StringSourceException {
            return this.resource != null ? this.computeRelative(this.resource, relativePath) : super.relativeSource(relativePath);
        }

        private LessSource computeRelative(Resource resource, String relativePath) throws LessSource.StringSourceException {
            try {
                String relativeResourceUri = this.computeRelativeResourceUri(resource.getUri(), relativePath);
                Resource relativeResource = Resource.create((String)relativeResourceUri, (ResourceType)ResourceType.CSS);
                String relativeResourceContent = IOUtils.toString((InputStream)this.locatorFactory.locate(relativeResourceUri), (String)"UTF-8");
                return new RelativeAwareLessSource(relativeResource, relativeResourceContent, this.locatorFactory);
            }
            catch (IOException e) {
                LOG.fine("Failed to compute relative resource: " + resource);
                throw new LessSource.StringSourceException();
            }
        }

        public String computeRelativeResourceUri(String originalResourceUri, String relativePath) {
            String fullPath = WroUtil.getFullPath((String)originalResourceUri) + relativePath;
            return WroUtil.normalize((String)fullPath);
        }
    }
}

