/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import java.util.ArrayList;

public class EmptyBodiesRemover {
    private ASTManipulator manipulator = new ASTManipulator();

    public void removeEmptyBodies(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        ArrayList<Comment> ownerlessComments = new ArrayList<Comment>();
        for (ASTCssNode aSTCssNode : childs) {
            this.removeEmptyBodies(aSTCssNode);
            if (this.shouldRemove(aSTCssNode)) {
                ownerlessComments.addAll(aSTCssNode.getOpeningComments());
                ownerlessComments.addAll(aSTCssNode.getTrailingComments());
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            this.manipulator.addOpeningComments(aSTCssNode, ownerlessComments);
            ownerlessComments = new ArrayList();
        }
    }

    private boolean shouldRemove(ASTCssNode kid) {
        if (!AstLogic.isBodyOwner(kid)) {
            return false;
        }
        BodyOwner bodyOwner = (BodyOwner)((Object)kid);
        return bodyOwner.getBody() != null && ((Body)bodyOwner.getBody()).isEmpty();
    }
}

