/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg.hsql;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.geotools.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotools.referencing.factory.epsg.hsql.HsqlEpsgDatabase;
import org.geotools.util.factory.Hints;

final class HsqlDialectEpsgFactory
extends AnsiDialectEpsgFactory {
    private static final Pattern OPENING_PATTERN = Pattern.compile("\\s+FROM\\s*\\(", 2);

    public HsqlDialectEpsgFactory(Hints hints) throws SQLException {
        super(hints, HsqlEpsgDatabase.createDataSource());
    }

    public HsqlDialectEpsgFactory(Hints hints, DataSource dataSource) {
        super(hints, dataSource);
    }

    @Override
    public String adaptSQL(String query) {
        block6: {
            Matcher matcher = OPENING_PATTERN.matcher(query = super.adaptSQL(query));
            if (!matcher.find()) break block6;
            int opening = matcher.end() - 1;
            int length = query.length();
            int closing = opening;
            int count = 0;
            while (true) {
                block7: {
                    if (closing >= length) {
                        return query;
                    }
                    switch (query.charAt(closing)) {
                        case '(': {
                            ++count;
                            break;
                        }
                        case ')': {
                            --count;
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    if (count == 0) break;
                }
                ++closing;
            }
            query = query.substring(0, opening) + query.substring(opening + 1, closing) + query.substring(closing + 1);
        }
        return query;
    }

    @Override
    protected void shutdown(boolean active) throws SQLException {
        if (active) {
            try (Statement statement = this.getConnection().createStatement();){
                statement.execute("SHUTDOWN");
            }
        }
        super.shutdown(active);
    }
}

