/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyBooleanMap;
import bak.pcj.map.CharKeyBooleanMap;
import bak.pcj.map.CharKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyBooleanMapAdapter
extends AbstractCharKeyBooleanMap
implements CharKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToCharKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToCharKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        this.lastValue = (Boolean)this.map.get(new Character(key));
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public CharKeyBooleanMapIterator entries() {
        return new CharKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(char key) {
        Boolean value = (Boolean)this.map.get(new Character(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(char key, boolean value) {
        Boolean oldValue = this.map.put(new Character(key), new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(char key) {
        Boolean value = (Boolean)this.map.remove(new Character(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(char key) {
        Boolean value = (Boolean)this.map.get(new Character(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isCharKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

