/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyBooleanMap;
import bak.pcj.map.ByteKeyBooleanMap;
import bak.pcj.map.ByteKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyBooleanMapAdapter
extends AbstractByteKeyBooleanMap
implements ByteKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToByteKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToByteKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        this.lastValue = (Boolean)this.map.get(new Byte(key));
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public ByteKeyBooleanMapIterator entries() {
        return new ByteKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(byte key) {
        Boolean value = (Boolean)this.map.get(new Byte(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(byte key, boolean value) {
        Boolean oldValue = this.map.put(new Byte(key), new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(byte key) {
        Boolean value = (Boolean)this.map.remove(new Byte(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(byte key) {
        Boolean value = (Boolean)this.map.get(new Byte(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isByteKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

