/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class GoogleClosureCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor,
Destroyable {
    public static final String ALIAS_SIMPLE = "googleClosureSimple";
    public static final String ALIAS_ADVANCED = "googleClosureAdvanced";
    public static final String ALIAS_WHITESPACE_ONLY = "googleClosureWhitespace";
    private CompilationLevel compilationLevel;
    private ObjectPoolHelper<CompilerOptions> optionsPool;
    @Inject
    private ReadOnlyContext context;
    private String encoding;

    public GoogleClosureCompressorProcessor() {
        this(CompilationLevel.SIMPLE_OPTIMIZATIONS);
    }

    public GoogleClosureCompressorProcessor(CompilationLevel compilationLevel) {
        Validate.notNull((Object)compilationLevel);
        this.optionsPool = new ObjectPoolHelper<CompilerOptions>(new ObjectFactory<CompilerOptions>(){

            public CompilerOptions create() {
                return GoogleClosureCompressorProcessor.this.newCompilerOptions();
            }
        });
        this.compilationLevel = compilationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        block7: {
            String content = IOUtils.toString((Reader)reader);
            CompilerOptions compilerOptions = this.optionsPool.getObject();
            Compiler compiler = this.newCompiler(compilerOptions);
            try {
                String fileName = resource == null ? "wro4j-processed-file.js" : resource.getUri();
                SourceFile[] input = new SourceFile[]{SourceFile.fromInputStream((String)fileName, (InputStream)new ByteArrayInputStream(content.getBytes(this.getEncoding())))};
                SourceFile[] externs = this.getExterns(resource);
                if (externs == null) {
                    externs = new SourceFile[]{};
                }
                Result result = null;
                result = compiler.compile(Arrays.asList(externs), Arrays.asList(input), compilerOptions);
                if (result.success) {
                    writer.write(compiler.toSource());
                    break block7;
                }
                throw new WroRuntimeException("Compilation has errors: " + Arrays.asList(result.errors));
            }
            catch (Exception e) {
                this.onException(e);
            }
            finally {
                reader.close();
                writer.close();
                this.optionsPool.returnObject(compilerOptions);
            }
        }
    }

    protected void onException(Exception e) {
        throw WroRuntimeException.wrap((Exception)e);
    }

    private String getEncoding() {
        if (this.encoding == null) {
            this.encoding = Context.isContextSet() ? this.context.getConfig().getEncoding() : "UTF-8";
        }
        return this.encoding;
    }

    private Compiler newCompiler(CompilerOptions compilerOptions) {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        this.compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        compiler.disableThreads();
        compiler.initOptions(compilerOptions);
        return compiler;
    }

    public GoogleClosureCompressorProcessor setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    protected SourceFile[] getExterns(Resource resource) {
        return new SourceFile[0];
    }

    public GoogleClosureCompressorProcessor setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
        return this;
    }

    protected CompilerOptions newCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset(this.getEncoding());
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        return options;
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void destroy() throws Exception {
        this.optionsPool.destroy();
    }
}

