/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.binders.BindChecksumsToJsonPayload;
import org.jclouds.chef.binders.BindCreateClientOptionsToJsonPayload;
import org.jclouds.chef.binders.BindGenerateKeyForClientToJsonPayload;
import org.jclouds.chef.binders.DatabagItemId;
import org.jclouds.chef.binders.EnvironmentName;
import org.jclouds.chef.binders.NodeName;
import org.jclouds.chef.binders.RoleName;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.domain.Role;
import org.jclouds.chef.domain.Sandbox;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.chef.domain.UploadSandbox;
import org.jclouds.chef.features.OrganizationApi;
import org.jclouds.chef.filters.SignedHeaderAuth;
import org.jclouds.chef.functions.ParseCookbookDefinitionFromJson;
import org.jclouds.chef.functions.ParseCookbookDefinitionListFromJson;
import org.jclouds.chef.functions.ParseCookbookNamesFromJson;
import org.jclouds.chef.functions.ParseCookbookVersionsFromJson;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.chef.functions.ParseSearchClientsFromJson;
import org.jclouds.chef.functions.ParseSearchDatabagFromJson;
import org.jclouds.chef.functions.ParseSearchEnvironmentsFromJson;
import org.jclouds.chef.functions.ParseSearchNodesFromJson;
import org.jclouds.chef.functions.ParseSearchRolesFromJson;
import org.jclouds.chef.functions.UriForResource;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.chef.options.SearchOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={SignedHeaderAuth.class})
@Headers(keys={"X-Chef-Version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/json"})
public interface ChefApi
extends Closeable {
    @Provides
    public ChefService chefService();

    @Delegate
    public Optional<OrganizationApi> organizationApi();

    @Named(value="client:list")
    @GET
    @Path(value="/clients")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listClients();

    @Named(value="client:get")
    @GET
    @Path(value="/clients/{clientname}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Client getClient(@PathParam(value="clientname") String var1);

    @Named(value="client:create")
    @POST
    @Path(value="/clients")
    @MapBinder(value=BindToJsonPayload.class)
    public Client createClient(@PayloadParam(value="name") String var1);

    @Named(value="client:create")
    @POST
    @Path(value="/clients")
    @MapBinder(value=BindCreateClientOptionsToJsonPayload.class)
    public Client createClient(@PayloadParam(value="name") String var1, CreateClientOptions var2);

    @Named(value="client:generatekey")
    @PUT
    @Path(value="/clients/{clientname}")
    public Client generateKeyForClient(@PathParam(value="clientname") @BinderParam(value=BindGenerateKeyForClientToJsonPayload.class) String var1);

    @Named(value="client:delete")
    @DELETE
    @Path(value="/clients/{clientname}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Client deleteClient(@PathParam(value="clientname") String var1);

    @Named(value="cookbook:list")
    @GET
    @Path(value="/cookbooks")
    @ResponseParser(value=ParseCookbookNamesFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listCookbooks();

    @SinceApiVersion(value="0.10.0")
    @Named(value="cookbook:list")
    @GET
    @ResponseParser(value=ParseCookbookDefinitionListFromJson.class)
    @Path(value="/environments/{environmentname}/cookbooks")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<CookbookDefinition> listCookbooksInEnvironment(@PathParam(value="environmentname") String var1);

    @SinceApiVersion(value="0.10.0")
    @Named(value="cookbook:list")
    @GET
    @ResponseParser(value=ParseCookbookDefinitionListFromJson.class)
    @Path(value="/environments/{environmentname}/cookbooks?num_versions={numversions}")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<CookbookDefinition> listCookbooksInEnvironment(@PathParam(value="environmentname") String var1, @PathParam(value="numversions") String var2);

    @Named(value="cookbook:versions")
    @GET
    @Path(value="/cookbooks/{cookbookname}")
    @ResponseParser(value=ParseCookbookVersionsFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listVersionsOfCookbook(@PathParam(value="cookbookname") String var1);

    @Named(value="cookbook:get")
    @GET
    @Path(value="/cookbooks/{cookbookname}/{version}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public CookbookVersion getCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:cookbook")
    @GET
    @ResponseParser(value=ParseCookbookDefinitionFromJson.class)
    @Path(value="/environments/{environmentname}/cookbooks/{cookbookname}")
    public CookbookDefinition getCookbookInEnvironment(@PathParam(value="environmentname") String var1, @PathParam(value="cookbookname") String var2);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:cookbook")
    @GET
    @ResponseParser(value=ParseCookbookDefinitionFromJson.class)
    @Path(value="/environments/{environmentname}/cookbooks/{cookbookname}?num_versions={numversions}")
    public CookbookDefinition getCookbookInEnvironment(@PathParam(value="environmentname") String var1, @PathParam(value="cookbookname") String var2, @PathParam(value="numversions") String var3);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:recipelist")
    @GET
    @Path(value="/environments/{environmentname}/recipes")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listRecipesInEnvironment(@PathParam(value="environmentname") String var1);

    @Named(value="cookbook:update")
    @PUT
    @Path(value="/cookbooks/{cookbookname}/{version}")
    public CookbookVersion updateCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2, @BinderParam(value=BindToJsonPayload.class) CookbookVersion var3);

    @Named(value="cookbook:delete")
    @DELETE
    @Path(value="/cookbooks/{cookbookname}/{version}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public CookbookVersion deleteCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2);

    @Named(value="databag:list")
    @GET
    @Path(value="/data")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listDatabags();

    @Named(value="databag:create")
    @POST
    @Path(value="/data")
    public void createDatabag(@WrapWith(value="name") String var1);

    @Named(value="databag:delete")
    @DELETE
    @Path(value="/data/{name}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteDatabag(@PathParam(value="name") String var1);

    @Named(value="databag:listitems")
    @GET
    @Path(value="/data/{name}")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listDatabagItems(@PathParam(value="name") String var1);

    @Named(value="databag:getitem")
    @GET
    @Path(value="/data/{databagName}/{databagItemId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public DatabagItem getDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") String var2);

    @Named(value="databag:createitem")
    @POST
    @Path(value="/data/{databagName}")
    public DatabagItem createDatabagItem(@PathParam(value="databagName") String var1, @BinderParam(value=BindToJsonPayload.class) DatabagItem var2);

    @Named(value="databag:updateitem")
    @PUT
    @Path(value="/data/{databagName}/{databagItemId}")
    public DatabagItem updateDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") @ParamParser(value=DatabagItemId.class) @BinderParam(value=BindToJsonPayload.class) DatabagItem var2);

    @Named(value="databag:deleteitem")
    @DELETE
    @Path(value="/data/{databagName}/{databagItemId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @SelectJson(value={"raw_data"})
    public DatabagItem deleteDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") String var2);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:list")
    @GET
    @Path(value="/environments")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listEnvironments();

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:get")
    @GET
    @Path(value="/environments/{environmentname}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Environment getEnvironment(@PathParam(value="environmentname") String var1);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:create")
    @POST
    @Path(value="/environments")
    public void createEnvironment(@BinderParam(value=BindToJsonPayload.class) Environment var1);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:update")
    @PUT
    @Path(value="/environments/{environmentname}")
    public Environment updateEnvironment(@PathParam(value="environmentname") @ParamParser(value=EnvironmentName.class) @BinderParam(value=BindToJsonPayload.class) Environment var1);

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:delete")
    @DELETE
    @Path(value="/environments/{environmentname}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Environment deleteEnvironment(@PathParam(value="environmentname") String var1);

    @Named(value="node:list")
    @GET
    @Path(value="/nodes")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listNodes();

    @SinceApiVersion(value="0.10.0")
    @Named(value="environment:nodelist")
    @GET
    @Path(value="/environments/{environmentname}/nodes")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listNodesInEnvironment(@PathParam(value="environmentname") String var1);

    @Named(value="node:get")
    @GET
    @Path(value="/nodes/{nodename}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Node getNode(@PathParam(value="nodename") String var1);

    @Named(value="node:create")
    @POST
    @Path(value="/nodes")
    public void createNode(@BinderParam(value=BindToJsonPayload.class) Node var1);

    @Named(value="node:update")
    @PUT
    @Path(value="/nodes/{nodename}")
    public Node updateNode(@PathParam(value="nodename") @ParamParser(value=NodeName.class) @BinderParam(value=BindToJsonPayload.class) Node var1);

    @Named(value="node:delete")
    @DELETE
    @Path(value="/nodes/{nodename}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Node deleteNode(@PathParam(value="nodename") String var1);

    @Named(value="role:list")
    @GET
    @Path(value="/roles")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listRoles();

    @Named(value="role:get")
    @GET
    @Path(value="/roles/{rolename}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Role getRole(@PathParam(value="rolename") String var1);

    @Named(value="role:create")
    @POST
    @Path(value="/roles")
    public void createRole(@BinderParam(value=BindToJsonPayload.class) Role var1);

    @Named(value="role:update")
    @PUT
    @Path(value="/roles/{rolename}")
    public Role updateRole(@PathParam(value="rolename") @ParamParser(value=RoleName.class) @BinderParam(value=BindToJsonPayload.class) Role var1);

    @Named(value="role:delete")
    @DELETE
    @Path(value="/roles/{rolename}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Role deleteRole(@PathParam(value="rolename") String var1);

    @Named(value="sandbox:upload")
    @POST
    @Path(value="/sandboxes")
    public UploadSandbox createUploadSandboxForChecksums(@BinderParam(value=BindChecksumsToJsonPayload.class) Set<List<Byte>> var1);

    @Named(value="content:upload")
    @PUT
    @Produces(value={"application/x-binary"})
    public void uploadContent(@EndpointParam URI var1, Payload var2);

    @Named(value="content:get")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @SkipEncoding(value={43, 32, 47, 61, 58, 59})
    public InputStream getResourceContents(@EndpointParam(parser=UriForResource.class) Resource var1);

    @Named(value="sandbox:commit")
    @PUT
    @Path(value="/sandboxes/{id}")
    public Sandbox commitSandbox(@PathParam(value="id") String var1, @WrapWith(value="is_completed") boolean var2);

    @Named(value="search:indexes")
    @GET
    @Path(value="/search")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<String> listSearchIndexes();

    @Named(value="search:clients")
    @GET
    @Path(value="/search/client")
    @ResponseParser(value=ParseSearchClientsFromJson.class)
    public SearchResult<? extends Client> searchClients();

    @Named(value="search:clients")
    @GET
    @Path(value="/search/client")
    @ResponseParser(value=ParseSearchClientsFromJson.class)
    public SearchResult<? extends Client> searchClients(SearchOptions var1);

    @Named(value="search:databag")
    @GET
    @Path(value="/search/{databagName}")
    @ResponseParser(value=ParseSearchDatabagFromJson.class)
    public SearchResult<? extends DatabagItem> searchDatabagItems(@PathParam(value="databagName") String var1);

    @Named(value="search:databag")
    @GET
    @Path(value="/search/{databagName}")
    @ResponseParser(value=ParseSearchDatabagFromJson.class)
    public SearchResult<? extends DatabagItem> searchDatabagItems(@PathParam(value="databagName") String var1, SearchOptions var2);

    @SinceApiVersion(value="0.10.0")
    @Named(value="search:environments")
    @GET
    @Path(value="/search/environment")
    @ResponseParser(value=ParseSearchEnvironmentsFromJson.class)
    public SearchResult<? extends Environment> searchEnvironments();

    @SinceApiVersion(value="0.10.0")
    @Named(value="search:environments")
    @GET
    @Path(value="/search/environment")
    @ResponseParser(value=ParseSearchEnvironmentsFromJson.class)
    public SearchResult<? extends Environment> searchEnvironments(SearchOptions var1);

    @Named(value="search:nodes")
    @GET
    @Path(value="/search/node")
    @ResponseParser(value=ParseSearchNodesFromJson.class)
    public SearchResult<? extends Node> searchNodes();

    @Named(value="search:nodes")
    @GET
    @Path(value="/search/node")
    @ResponseParser(value=ParseSearchNodesFromJson.class)
    public SearchResult<? extends Node> searchNodes(SearchOptions var1);

    @Named(value="search:roles")
    @GET
    @Path(value="/search/role")
    @ResponseParser(value=ParseSearchRolesFromJson.class)
    public SearchResult<? extends Role> searchRoles();

    @Named(value="search:roles")
    @GET
    @Path(value="/search/role")
    @ResponseParser(value=ParseSearchRolesFromJson.class)
    public SearchResult<? extends Role> searchRoles(SearchOptions var1);
}

