/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibJPEGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi"};
    private boolean registered = false;

    public CLibJPEGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            List list = ImageUtil.getJDKImageReaderWriterSPI(registry, "JPEG", false);
            for (int i = 0; i < list.size(); ++i) {
                registry.setOrdering(category, this, list.get(i));
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        int bitDepth;
        ColorModel colorModel = type.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        SampleModel sampleModel = type.getSampleModel();
        if (colorModel != null) {
            int[] componentSize = colorModel.getComponentSize();
            bitDepth = componentSize[0];
            for (int i = 1; i < componentSize.length; ++i) {
                if (componentSize[i] == bitDepth) continue;
                return false;
            }
        } else {
            int[] sampleSize = sampleModel.getSampleSize();
            bitDepth = sampleSize[0];
            for (int i = 1; i < sampleSize.length; ++i) {
                if (sampleSize[i] == bitDepth) continue;
                return false;
            }
        }
        if (bitDepth > 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands >= 1 && numBands <= 4;
    }

    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " natively-accelerated JPEG Image Writer";
        return desc;
    }

    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new CLibJPEGImageWriter(this);
    }
}

