/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.calendars.Calendar;
import org.elasticsearch.client.ml.calendars.ScheduledEvent;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PostCalendarEventRequest
extends ActionRequest
implements ToXContentObject {
    private final String calendarId;
    private final List<ScheduledEvent> scheduledEvents;
    public static final String INCLUDE_CALENDAR_ID_KEY = "include_calendar_id";
    public static final ParseField EVENTS = new ParseField("events", new String[0]);
    public static final ConstructingObjectParser<PostCalendarEventRequest, Void> PARSER = new ConstructingObjectParser("post_calendar_event_request", a -> new PostCalendarEventRequest((String)a[0], (List)a[1]));
    public static final ToXContent.MapParams EXCLUDE_CALENDAR_ID_PARAMS;

    public PostCalendarEventRequest(String calendarId, List<ScheduledEvent> scheduledEvents) {
        this.calendarId = Objects.requireNonNull(calendarId, "[calendar_id] must not be null.");
        this.scheduledEvents = Objects.requireNonNull(scheduledEvents, "[events] must not be null.");
        if (scheduledEvents.isEmpty()) {
            throw new IllegalArgumentException("At least 1 event is required");
        }
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public List<ScheduledEvent> getScheduledEvents() {
        return this.scheduledEvents;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(INCLUDE_CALENDAR_ID_KEY, true)) {
            builder.field(Calendar.ID.getPreferredName(), this.calendarId);
        }
        builder.field(EVENTS.getPreferredName(), this.scheduledEvents);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.calendarId, this.scheduledEvents);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PostCalendarEventRequest other = (PostCalendarEventRequest)((Object)obj);
        return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.scheduledEvents, other.scheduledEvents);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Calendar.ID);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> (ScheduledEvent)ScheduledEvent.PARSER.apply(p, null), EVENTS);
        EXCLUDE_CALENDAR_ID_PARAMS = new ToXContent.MapParams(Collections.singletonMap(INCLUDE_CALENDAR_ID_KEY, Boolean.toString(false)));
    }
}

