/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HeaderParser {
    private static final Logger LOG = Log.getLogger(Parser.class);
    private State state = State.VERSION;
    private int cursor;
    private int version;
    private int type;
    private int request;
    private int length;
    private int padding;

    public boolean parse(ByteBuffer buffer) {
        block10: while (buffer.hasRemaining()) {
            switch (this.state) {
                case VERSION: {
                    this.version = buffer.get() & 0xFF;
                    this.state = State.TYPE;
                    continue block10;
                }
                case TYPE: {
                    this.type = buffer.get() & 0xFF;
                    this.state = State.REQUEST;
                    continue block10;
                }
                case REQUEST: {
                    if (buffer.remaining() >= 2) {
                        this.request = buffer.getShort() & 0xFFFF;
                        this.state = State.LENGTH;
                        continue block10;
                    }
                    this.state = State.REQUEST_BYTES;
                    this.cursor = 0;
                    continue block10;
                }
                case REQUEST_BYTES: {
                    int halfShort = buffer.get() & 0xFF;
                    this.request = (this.request << 8) + halfShort;
                    if (++this.cursor != 2) continue block10;
                    this.state = State.LENGTH;
                    continue block10;
                }
                case LENGTH: {
                    if (buffer.remaining() >= 2) {
                        this.length = buffer.getShort() & 0xFFFF;
                        this.state = State.PADDING;
                        continue block10;
                    }
                    this.state = State.LENGTH_BYTES;
                    this.cursor = 0;
                    continue block10;
                }
                case LENGTH_BYTES: {
                    int halfShort = buffer.get() & 0xFF;
                    this.length = (this.length << 8) + halfShort;
                    if (++this.cursor != 2) continue block10;
                    this.state = State.PADDING;
                    continue block10;
                }
                case PADDING: {
                    this.padding = buffer.get() & 0xFF;
                    this.state = State.RESERVED;
                    continue block10;
                }
                case RESERVED: {
                    buffer.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Parsed request {} header {} length={}", new Object[]{this.getRequest(), this.getFrameType(), this.getContentLength()});
                    }
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    public FCGI.FrameType getFrameType() {
        return FCGI.FrameType.from(this.type);
    }

    public int getRequest() {
        return this.request;
    }

    public int getContentLength() {
        return this.length;
    }

    public int getPaddingLength() {
        return this.padding;
    }

    protected void reset() {
        this.state = State.VERSION;
        this.cursor = 0;
        this.version = 0;
        this.type = 0;
        this.request = 0;
        this.length = 0;
        this.padding = 0;
    }

    private static enum State {
        VERSION,
        TYPE,
        REQUEST,
        REQUEST_BYTES,
        LENGTH,
        LENGTH_BYTES,
        PADDING,
        RESERVED;

    }
}

