/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private Receiver nextReceiver;
    private int pendingStartTag = -2;
    private int level = -1;
    private boolean[] currentLevelIsDocument = new boolean[20];
    private Boolean elementIsInNullNamespace;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private String[] pendingAttValue = new String[20];
    private int[] pendingAttLocation = new int[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = -1;
    private int startElementProperties;
    private int startElementLocationId;
    private boolean declaresDefaultNamespace;
    private int hostLanguage = 50;
    private boolean started = false;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public void setReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public boolean contentHasBeenWritten() {
        return this.started;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int properties) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        } else if (this.pendingStartTag >= 0) {
            this.startContent();
            this.pendingStartTag = -2;
        }
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            boolean[] b2 = new boolean[this.level * 2];
            System.arraycopy(this.currentLevelIsDocument, 0, b2, 0, this.level);
            this.currentLevelIsDocument = b2;
        }
        this.currentLevelIsDocument[this.level] = true;
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
        --this.level;
    }

    public void characters(CharSequence s, int locationId, int properties) throws XPathException {
        this.previousAtomic = false;
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.nextReceiver.characters(s, locationId, properties);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        ++this.level;
        this.started = true;
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.startElementProperties = properties;
        this.startElementLocationId = locationId;
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = nameCode;
        this.elementIsInNullNamespace = null;
        this.declaresDefaultNamespace = false;
        this.currentSimpleType = typeCode;
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            boolean[] b2 = new boolean[this.level * 2];
            System.arraycopy(this.currentLevelIsDocument, 0, b2, 0, this.level);
            this.currentLevelIsDocument = b2;
        }
        this.currentLevelIsDocument[this.level] = false;
    }

    public void namespace(int nscode, int properties) throws XPathException {
        NamePool pool = this.getNamePool();
        if (this.pendingStartTag < 0) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, pool.getPrefixFromNamespaceCode(nscode), this.hostLanguage, this.pendingStartTag == -2, this.getPipelineConfiguration().isSerializing());
        }
        boolean rejectDuplicates = (properties & 0x20) != 0;
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nscode == this.pendingNSList[i]) {
                return;
            }
            if (nscode >> 16 != this.pendingNSList[i] >> 16) continue;
            if (rejectDuplicates) {
                String prefix = pool.getPrefixFromNamespaceCode(nscode);
                String uri1 = pool.getURIFromNamespaceCode(nscode);
                String uri2 = pool.getURIFromNamespaceCode(this.pendingNSList[i]);
                XPathException err = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.length() == 0 ? "\"\"" : prefix) + ", URI=" + (uri1.length() == 0 ? "\"\"" : uri1) + ", URI=" + (uri2.length() == 0 ? "\"\"" : uri2) + ")");
                err.setErrorCode("XTDE0430");
                throw err;
            }
            return;
        }
        if (nscode >> 16 == 0 && (nscode & 0xFFFF) != 0) {
            this.declaresDefaultNamespace = true;
            if (this.elementIsInNullNamespace == null) {
                this.elementIsInNullNamespace = pool.getURI(this.pendingStartTag).equals("");
            }
            if (this.elementIsInNullNamespace.booleanValue()) {
                XPathException err = new XPathException("Cannot output a namespace node for the default namespace when the element is in no namespace");
                err.setErrorCode("XTDE0440");
                throw err;
            }
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] newlist = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, newlist, 0, this.pendingNSListSize);
            this.pendingNSList = newlist;
        }
        this.pendingNSList[this.pendingNSListSize++] = nscode;
        this.previousAtomic = false;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.pendingStartTag < 0) {
            NoOpenStartTagException err = NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(nameCode), this.hostLanguage, this.level < 0 || this.currentLevelIsDocument[this.level], this.getPipelineConfiguration().isSerializing());
            LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
            if (lp != null) {
                err.setLocator(new ExpressionLocation(lp, locationId));
            }
            throw err;
        }
        for (int a = 0; a < this.pendingAttListSize; ++a) {
            if ((this.pendingAttCode[a] & 0xFFFFF) != (nameCode & 0xFFFFF)) continue;
            if (this.hostLanguage == 50) {
                this.pendingAttType[a] = typeCode;
                this.pendingAttValue[a] = ((Object)value).toString();
                this.pendingAttLocation[a] = locationId;
                this.pendingAttProp[a] = properties;
                return;
            }
            XPathException err = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2));
            err.setErrorCode("XQDY0025");
            throw err;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] attCode2 = new int[this.pendingAttListSize * 2];
            int[] attType2 = new int[this.pendingAttListSize * 2];
            String[] attValue2 = new String[this.pendingAttListSize * 2];
            int[] attLoc2 = new int[this.pendingAttListSize * 2];
            int[] attProp2 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, attCode2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, attType2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, attValue2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttLocation, 0, attLoc2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, attProp2, 0, this.pendingAttListSize);
            this.pendingAttCode = attCode2;
            this.pendingAttType = attType2;
            this.pendingAttValue = attValue2;
            this.pendingAttLocation = attLoc2;
            this.pendingAttProp = attProp2;
        }
        this.pendingAttCode[this.pendingAttListSize] = nameCode;
        this.pendingAttType[this.pendingAttListSize] = typeCode;
        this.pendingAttValue[this.pendingAttListSize] = ((Object)value).toString();
        this.pendingAttLocation[this.pendingAttListSize] = locationId;
        this.pendingAttProp[this.pendingAttListSize] = properties;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int nameCode, int seq) throws XPathException {
        NamePool namePool = this.getNamePool();
        int nscode = namePool.getNamespaceCode(nameCode);
        if (nscode == -1) {
            nscode = namePool.allocateNamespaceCode(nameCode);
        }
        int nsprefix = nscode >> 16;
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nsprefix != this.pendingNSList[i] >> 16) continue;
            if ((nscode & 0xFFFF) == (this.pendingNSList[i] & 0xFFFF)) {
                return nameCode;
            }
            String prefix = this.getSubstitutePrefix(nscode, seq);
            int newCode = namePool.allocate(prefix, namePool.getURI(nameCode), namePool.getLocalName(nameCode));
            this.namespace(namePool.allocateNamespaceCode(newCode), 0);
            return newCode;
        }
        this.namespace(nscode, 0);
        return nameCode;
    }

    private String getSubstitutePrefix(int nscode, int seq) {
        String prefix = this.getNamePool().getPrefixFromNamespaceCode(nscode);
        return prefix + '_' + seq;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        } else {
            this.pendingStartTag = -2;
        }
        this.nextReceiver.endElement();
        --this.level;
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, int locationId, int properties) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.nextReceiver.comment(comment, locationId, properties);
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        this.previousAtomic = false;
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item != null) {
            if (item instanceof AtomicValue) {
                if (this.previousAtomic) {
                    this.characters(" ", locationId, 0);
                }
                this.characters(item.getStringValueCS(), locationId, 0);
                this.previousAtomic = true;
            } else if (((NodeInfo)item).getNodeKind() == 9) {
                Item it;
                this.startDocument(0);
                AxisIterator iter = ((NodeInfo)item).iterateAxis((byte)3);
                while ((it = iter.next()) != null) {
                    this.append(it, locationId, copyNamespaces);
                }
                this.endDocument();
                this.previousAtomic = false;
            } else {
                try {
                    ((NodeInfo)item).copy(this, copyNamespaces, true, locationId);
                }
                catch (CopyNamespaceSensitiveException e) {
                    e.setErrorCode(this.hostLanguage == 50 ? "XTTE0950" : "XQTY0086");
                    throw e;
                }
                this.previousAtomic = false;
            }
        }
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int a;
        if (this.pendingStartTag < 0) {
            return;
        }
        this.started = true;
        int props = this.startElementProperties;
        int elcode = this.pendingStartTag;
        if (this.declaresDefaultNamespace || NamePool.getPrefixIndex(elcode) != 0) {
            elcode = this.checkProposedPrefix(this.pendingStartTag, 0);
            props = this.startElementProperties | 0x40;
        }
        this.nextReceiver.startElement(elcode, this.currentSimpleType, this.startElementLocationId, props);
        for (a = 0; a < this.pendingAttListSize; ++a) {
            int attcode = this.pendingAttCode[a];
            if (NamePool.getPrefixIndex(attcode) == 0) continue;
            this.pendingAttCode[a] = this.checkProposedPrefix(attcode, a + 1);
        }
        for (int n = 0; n < this.pendingNSListSize; ++n) {
            this.nextReceiver.namespace(this.pendingNSList[n], 0);
        }
        for (a = 0; a < this.pendingAttListSize; ++a) {
            this.nextReceiver.attribute(this.pendingAttCode[a], this.pendingAttType[a], this.pendingAttValue[a], this.pendingAttLocation[a], this.pendingAttProp[a]);
        }
        this.nextReceiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

