/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.iface;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.provider.iface.IRServiceDescriptor;
import org.jzkit.search.provider.iface.JZKitPluginMetadata;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SearchableFactory
implements ApplicationContextAware {
    private ApplicationContext ctx;
    private Map plugin_map = new HashMap();
    public static Log log = LogFactory.getLog(SearchableFactory.class);

    public void init() {
        log.debug((Object)"SearchableFactory scanning for plugins....");
        Map backend_plugins = this.ctx.getBeansOfType(JZKitPluginMetadata.class);
        if (backend_plugins != null) {
            for (Map.Entry e : backend_plugins.entrySet()) {
                log.debug((Object)("Registered: " + e.getKey() + " = " + e.getValue()));
                JZKitPluginMetadata plugin_metadata = (JZKitPluginMetadata)e.getValue();
                this.plugin_map.put(plugin_metadata.getPluginCode(), plugin_metadata.getPluginClassName());
                log.debug((Object)("setting " + plugin_metadata.getPluginCode() + "=" + plugin_metadata.getPluginClassName()));
            }
        }
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Searchable create(IRServiceDescriptor connection_descriptor) throws SearchException {
        System.err.println("Create service " + connection_descriptor);
        Searchable result = null;
        if (connection_descriptor != null && connection_descriptor.getProtocol() != null) {
            String class_name = (String)this.plugin_map.get(connection_descriptor.getProtocol());
            try {
                System.err.println("New instance of " + class_name);
                Class<?> searchable_class = Class.forName(class_name);
                result = (Searchable)searchable_class.newInstance();
                result.setApplicationContext(this.ctx);
                for (String property_name : connection_descriptor.getPreferences().keySet()) {
                    String property_value = connection_descriptor.getPreferences().get(property_name);
                    System.err.println("Setting " + property_name + " to object of class " + property_value.getClass() + " value=" + property_value);
                    BeanUtils.setProperty((Object)result, (String)property_name, (Object)property_value);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new SearchException("Unable to locate searchable class: " + class_name, cnfe);
            }
            catch (InstantiationException ie) {
                throw new SearchException("Probem creating new SearchServiceFactory - " + class_name + " ie", ie);
            }
            catch (IllegalAccessException iae) {
                throw new SearchException("Probem creating new SearchServiceFactory", iae);
            }
            catch (InvocationTargetException ite) {
                throw new SearchException("Probem creating new SearchServiceFactory", ite);
            }
        }
        return result;
    }

    public Searchable create(String connection_descriptor_string) throws SearchException {
        return this.create(new IRServiceDescriptor(connection_descriptor_string));
    }
}

