/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;

public class ParseOnlyRecord
implements Function<HttpResponse, RecordDetail> {
    private final ParseJson<Map<String, List<ParseRecord.RawRecord>>> json;

    @Inject
    ParseOnlyRecord(ParseJson<Map<String, List<ParseRecord.RawRecord>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public RecordDetail apply(HttpResponse response) {
        Map records = (Map)this.json.apply(response);
        if (records == null) {
            return null;
        }
        ParseRecord.RawRecord rawRecord = (ParseRecord.RawRecord)Iterables.getOnlyElement((Iterable)((Iterable)records.get("records")));
        return (RecordDetail)ParseRecord.toRecordDetails.apply((Object)rawRecord);
    }
}

