/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class CancellableTasksTracker<T> {
    private final T[] empty;
    private final Map<Long, T> byTaskId = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final Map<TaskId, T[]> byParentTaskId = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public CancellableTasksTracker(T[] empty) {
        assert (empty.length == 0);
        this.empty = empty;
    }

    public void put(Task task, T item) {
        long taskId = task.getId();
        if (task.getParentTaskId().isSet()) {
            this.byParentTaskId.compute(task.getParentTaskId(), (ignored, oldValue) -> {
                if (oldValue == null) {
                    oldValue = this.empty;
                }
                Object[] newValue = Arrays.copyOf(oldValue, ((Object[])oldValue).length + 1);
                newValue[oldValue.length] = item;
                return newValue;
            });
        }
        T oldItem = this.byTaskId.put(taskId, item);
        assert (oldItem == null) : "duplicate entry for task [" + taskId + "]";
    }

    public T get(long id) {
        return this.byTaskId.get(id);
    }

    public T remove(Task task) {
        long taskId = task.getId();
        Object oldItem = this.byTaskId.remove(taskId);
        if (oldItem != null && task.getParentTaskId().isSet()) {
            this.byParentTaskId.compute(task.getParentTaskId(), (ignored, oldValue) -> {
                if (oldValue == null) {
                    return null;
                }
                if (((Object[])oldValue).length == 1) {
                    if (oldValue[0] == oldItem) {
                        return null;
                    }
                    return oldValue;
                }
                if (oldValue[0] == oldItem) {
                    return Arrays.copyOfRange(oldValue, 1, ((Object[])oldValue).length);
                }
                for (int i = 1; i < ((Object[])oldValue).length; ++i) {
                    if (oldValue[i] != oldItem) continue;
                    Object[] newValue = Arrays.copyOf(oldValue, ((Object[])oldValue).length - 1);
                    System.arraycopy(oldValue, i + 1, newValue, i, ((Object[])oldValue).length - i - 1);
                    return newValue;
                }
                return oldValue;
            });
        }
        return oldItem;
    }

    public Collection<T> values() {
        return this.byTaskId.values();
    }

    public Stream<T> getByParent(TaskId parentTaskId) {
        T[] byParent = this.byParentTaskId.get(parentTaskId);
        if (byParent == null) {
            return Stream.empty();
        }
        return Arrays.stream(byParent);
    }

    boolean assertConsistent() {
        assert (!this.byTaskId.isEmpty() || this.byParentTaskId.isEmpty());
        HashSet<T> byTaskValues = new HashSet<T>(this.byTaskId.values());
        for (T[] byParent : this.byParentTaskId.values()) {
            assert (byParent.length > 0);
            for (T t : byParent) {
                assert (byTaskValues.contains(t));
            }
        }
        return true;
    }
}

