/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shutdown;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.plugins.ShutdownAwarePlugin;

public class PluginShutdownService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PluginShutdownService.class);
    public List<ShutdownAwarePlugin> plugins;

    public PluginShutdownService(@Nullable List<ShutdownAwarePlugin> plugins) {
        this.plugins = plugins == null ? Collections.emptyList() : plugins;
    }

    public static Set<String> shutdownNodes(ClusterState clusterState) {
        return NodesShutdownMetadata.getShutdowns(clusterState).map(NodesShutdownMetadata::getAllNodeMetadataMap).map(Map::keySet).orElse(Collections.emptySet());
    }

    public static Set<String> shutdownTypeNodes(ClusterState clusterState, SingleNodeShutdownMetadata.Type shutdownType) {
        return NodesShutdownMetadata.getShutdowns(clusterState).map(NodesShutdownMetadata::getAllNodeMetadataMap).map(m -> m.entrySet().stream().filter(e -> ((SingleNodeShutdownMetadata)e.getValue()).getType() == shutdownType).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).map(Map::keySet).orElse(Collections.emptySet());
    }

    public boolean readyToShutdown(String nodeId, SingleNodeShutdownMetadata.Type shutdownType) {
        for (ShutdownAwarePlugin plugin : this.plugins) {
            try {
                if (plugin.safeToShutdown(nodeId, shutdownType)) continue;
                logger.trace("shutdown aware plugin [{}] is not yet ready for shutdown", (Object)plugin);
                return false;
            }
            catch (Exception e) {
                logger.warn("uncaught exception when retrieving whether plugin is ready for node shutdown", (Throwable)e);
            }
        }
        return true;
    }

    public void signalShutdown(ClusterState state) {
        Set<String> shutdownNodes = PluginShutdownService.shutdownNodes(state);
        for (ShutdownAwarePlugin plugin : this.plugins) {
            try {
                plugin.signalShutdown(shutdownNodes);
            }
            catch (Exception e) {
                logger.warn((Message)new ParameterizedMessage("uncaught exception when notifying plugins of nodes {} shutdown", shutdownNodes), (Throwable)e);
            }
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.signalShutdown(event.state());
    }
}

