/*
 * Decompiled with CFR 0.152.
 */
package opendap.util.geturl;

import java.io.FileNotFoundException;
import java.io.IOException;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DConnect;
import opendap.dap.DDS;
import opendap.dap.DataDDS;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;
import opendap.util.geturl.gui.StatusWindow;

public class Geturl {
    private static final String VERSION = "0.1 Beta";

    private static void usage() {
        System.err.println("Usage: geturl [dDagVvk] [c <expr>] [t <codes>] [m <num>] <url> [<url> ...]");
        System.err.println("[gVvk] [t <codes>] <file> [<file> ...]");
        System.err.println("In the first form of the command, dereference the URL");
        System.err.println("perform the requested operations. In the second, assume");
        System.err.println("the files are OPeNDAP DAP2 data objects (stored in files or read");
        System.err.println("from pipes) and process them as if -D were given.");
        System.err.println("        d: For each URL, get the DAP2 DDS.");
        System.err.println("        x: For each URL, get the Prototype DDX.");
        System.err.println("        a: For each URL, get the DAP2 DAS.");
        System.err.println("        D: For each URL, get the DAP2 Data.");
        System.err.println("        X: For each URL, get the DAP2 Data via a DDX.");
        System.err.println("        g: Show the progress GUI.");
        System.err.println("        v: Verbose.");
        System.err.println("        V: Version.");
        System.err.println("        c: <expr> is a contraint expression. Used with -D.");
        System.err.println("           NB: You can use a `?' for the CE also.");
        System.err.println("        m: Request the same URL <num> times.");
        System.err.println("        z: Don't ask the server to compress data.");
        System.err.println("        p: Dump the DAP2 Data as binary, not text.");
        System.err.println("       Without D, d or a, print the URL.");
    }

    public static void main(String[] args) {
        boolean get_das = false;
        boolean get_dds = false;
        boolean get_ddx = false;
        boolean get_data = false;
        boolean get_dataX = false;
        boolean dump_data = false;
        boolean gui = false;
        boolean cexpr = false;
        boolean verbose = false;
        boolean multi = false;
        boolean accept_deflate = true;
        int times = 1;
        String expr = "";
        try {
            String[] argp;
            String optVal;
            Getopts opts = new Getopts("dxaDXgVvc:m:zp", args);
            if (opts.getSwitch((Character)new Character((char)'d')).set) {
                get_dds = true;
            }
            if (opts.getSwitch((Character)new Character((char)'x')).set) {
                get_ddx = true;
            }
            if (opts.getSwitch((Character)new Character((char)'a')).set) {
                get_das = true;
            }
            if (opts.getSwitch((Character)new Character((char)'D')).set) {
                get_data = true;
            }
            if (opts.getSwitch((Character)new Character((char)'X')).set) {
                get_dataX = true;
            }
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                get_data = true;
                dump_data = true;
            }
            if (opts.getSwitch((Character)new Character((char)'V')).set) {
                System.err.println("geturl version: 0.1 Beta");
                System.exit(0);
            }
            if (opts.getSwitch((Character)new Character((char)'v')).set) {
                verbose = true;
            }
            if (opts.getSwitch((Character)new Character((char)'g')).set) {
                gui = true;
            }
            if ((optVal = opts.getSwitch((Character)new Character((char)'c')).val) != null) {
                cexpr = true;
                expr = optVal;
            }
            if ((optVal = opts.getSwitch((Character)new Character((char)'m')).val) != null) {
                multi = true;
                times = Integer.parseInt(optVal);
            }
            if (opts.getSwitch((Character)new Character((char)'z')).set) {
                accept_deflate = false;
            }
            if ((argp = opts.argList()).length == 0) {
                if (verbose) {
                    System.err.println("Assuming standard input is a OPeNDAP DAP2 data stream.");
                }
                DConnect url = new DConnect(System.in);
                try {
                    StatusWindow ui = null;
                    if (gui) {
                        ui = new StatusWindow("stdin");
                    }
                    DataDDS dds = url.getData(ui);
                    Geturl.processData(url, dds, verbose, dump_data, accept_deflate);
                }
                catch (DAP2Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            for (int i = 0; i < argp.length; ++i) {
                DataDDS dds;
                StatusWindow ui;
                DDS dds2;
                String nextURL = argp[i];
                if (verbose) {
                    System.err.println("Fetching: " + nextURL);
                }
                DConnect url = null;
                try {
                    url = new DConnect(nextURL, accept_deflate);
                }
                catch (FileNotFoundException e) {
                    System.err.println(nextURL + " is neither a valid URL nor a filename.");
                    System.exit(1);
                }
                if (url.isLocal()) {
                    if (verbose) {
                        System.err.println("Assuming that the argument " + nextURL + " is a file\n" + "that contains a OPeNDAP DAP2 data object; decoding.");
                    }
                    try {
                        StatusWindow ui2 = null;
                        if (gui) {
                            ui2 = new StatusWindow(nextURL);
                        }
                        dds2 = url.getData(ui2);
                        Geturl.processData(url, (DataDDS)dds2, verbose, dump_data, accept_deflate);
                    }
                    catch (DAP2Exception e) {
                        System.err.println(e);
                        System.exit(1);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                if (get_das) {
                    for (int j = 0; j < times; ++j) {
                        try {
                            DAS das = url.getDAS();
                            if (verbose) {
                                System.err.println("Server version: " + url.getServerVersion());
                                System.err.println("DAS:");
                            }
                            das.print(System.out);
                            continue;
                        }
                        catch (DAP2Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            System.exit(1);
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                if (get_dds) {
                    for (int j = 0; j < times; ++j) {
                        try {
                            dds2 = url.getDDS(expr);
                            if (verbose) {
                                System.err.println("Server version: " + url.getServerVersion());
                                System.err.println("CE:" + expr + "'");
                                System.err.println("DDS:");
                            }
                            dds2.print(System.out);
                            continue;
                        }
                        catch (DAP2Exception e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                if (get_ddx) {
                    for (int j = 0; j < times; ++j) {
                        try {
                            dds2 = url.getDDX(expr);
                            if (verbose) {
                                System.err.println("Server version: " + url.getServerVersion());
                                System.err.println("CE:'" + expr + "'");
                                System.err.println("DDX:");
                            }
                            dds2.printXML(System.out);
                            continue;
                        }
                        catch (DAP2Exception e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                if (get_data) {
                    if (!cexpr && nextURL.indexOf(63) == -1) {
                        System.err.println("Must supply a constraint expression with -D.");
                        continue;
                    }
                    for (int j = 0; j < times; ++j) {
                        try {
                            ui = null;
                            if (gui) {
                                ui = new StatusWindow(nextURL);
                            }
                            dds = url.getData(expr, ui);
                            Geturl.processData(url, dds, verbose, dump_data, accept_deflate);
                            continue;
                        }
                        catch (DAP2Exception e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            System.err.println(e);
                            System.exit(1);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                if (!get_dataX) continue;
                if (!cexpr && nextURL.indexOf(63) == -1) {
                    System.err.println("Must supply a constraint expression with -D.");
                    continue;
                }
                for (int j = 0; j < times; ++j) {
                    try {
                        ui = null;
                        if (gui) {
                            ui = new StatusWindow(nextURL);
                        }
                        dds = url.getDataDDX(expr);
                        url.getBlobData(dds, ui);
                        Geturl.processDDXData(url, dds, verbose, dump_data, accept_deflate);
                        continue;
                    }
                    catch (DAP2Exception e) {
                        System.err.println(e);
                        System.exit(1);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println(e);
                        System.exit(1);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        }
        catch (InvalidSwitch e) {
            Geturl.usage();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void processData(DConnect url, DataDDS dds, boolean verbose, boolean dump_data, boolean compress) {
        if (verbose) {
            System.err.println("Server version: " + url.getServerVersion());
        }
        if (dump_data) {
            try {
                dds.externalize(System.out, compress, true);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        } else {
            System.out.println("The data:");
            dds.printVal(System.out);
            System.out.println();
        }
    }

    private static void processDDXData(DConnect url, DataDDS dds, boolean verbose, boolean dump_data, boolean compress) {
        if (verbose) {
            System.err.println("Server version: " + url.getServerVersion());
        }
        if (dump_data) {
            try {
                dds.externalize(System.out, compress, true);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        } else {
            if (verbose) {
                System.out.println("\nThe DDX:");
                dds.printXML(System.out);
            }
            System.out.println("\nThe data:");
            dds.printVal(System.out);
            System.out.println();
        }
    }
}

