/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.trove.v1.binders.BindCreateInstanceToJson;
import org.jclouds.openstack.trove.v1.domain.Instance;
import org.jclouds.openstack.trove.v1.functions.ParsePasswordFromRootedInstance;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface InstanceApi {
    @Named(value="instance:create")
    @POST
    @Path(value="/instances")
    @SelectJson(value={"instance"})
    @Consumes(value={"application/json"})
    @MapBinder(value=BindCreateInstanceToJson.class)
    public Instance create(@PayloadParam(value="flavorRef") int var1, @PayloadParam(value="size") int var2, @PayloadParam(value="name") String var3);

    @Named(value="instance:create")
    @POST
    @Path(value="/instances")
    @SelectJson(value={"instance"})
    @Consumes(value={"application/json"})
    @MapBinder(value=BindCreateInstanceToJson.class)
    public Instance create(@PayloadParam(value="flavorRef") String var1, @PayloadParam(value="size") int var2, @PayloadParam(value="name") String var3);

    @Named(value="instances:delete/{id}")
    @DELETE
    @Path(value="/instances/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="instances/{id}/root")
    @POST
    @Path(value="/instances/{id}/root")
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParsePasswordFromRootedInstance.class)
    public String enableRoot(@PathParam(value="id") String var1);

    @Named(value="instances/{id}/root")
    @GET
    @Path(value="/instances/{id}/root")
    @Consumes(value={"application/json"})
    @SelectJson(value={"rootEnabled"})
    public boolean isRooted(@PathParam(value="id") String var1);

    @Named(value="instance:list")
    @GET
    @Path(value="/instances")
    @SelectJson(value={"instances"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Instance> list();

    @Named(value="instances:get/{id}")
    @GET
    @Path(value="/instances/{id}")
    @SelectJson(value={"instance"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Instance get(@PathParam(value="id") String var1);
}

