/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.iterators;

import com.sun.media.jai.iterator.RectIterCSMFloat;
import com.sun.media.jai.iterator.RectIterFallback;
import com.sun.media.jai.iterator.WrapperRI;
import com.sun.media.jai.iterator.WrapperWRI;
import com.sun.media.jai.iterator.WritableRectIterCSMByte;
import com.sun.media.jai.iterator.WritableRectIterCSMFloat;
import com.sun.media.jai.iterator.WritableRectIterFallback;
import it.geosolutions.jaiext.iterators.RectIterCSMByte;
import it.geosolutions.jaiext.iterators.RectIterCSMByteABGR;
import it.geosolutions.jaiext.iterators.RectIterCSMByteABGRSingleBank;
import it.geosolutions.jaiext.iterators.WritableRectIterCSMByteIndexed;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.WritableRectIter;

public class RectIterFactory {
    private RectIterFactory() {
    }

    public static RectIter create(RenderedImage im, Rectangle bounds) {
        SampleModel sm;
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        if ((sm = im.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sm.getDataType()) {
                case 0: {
                    ComponentSampleModel csm = (ComponentSampleModel)sm;
                    int[] offsets = csm.getBandOffsets();
                    if (offsets.length == 4 && offsets[0] == 3 && offsets[1] == 2 && offsets[2] == 1 && offsets[3] == 0) {
                        int[] bankIndices = csm.getBankIndices();
                        if (bankIndices.length == 4 && bankIndices[0] == 0 && bankIndices[1] == 0 && bankIndices[2] == 0 && bankIndices[3] == 0) {
                            return new RectIterCSMByteABGRSingleBank(im, bounds);
                        }
                        return new RectIterCSMByteABGR(im, bounds);
                    }
                    return new RectIterCSMByte(im, bounds);
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    return new RectIterCSMFloat(im, bounds);
                }
            }
        }
        return new RectIterFallback(im, bounds);
    }

    public static RectIter create(Raster ras, Rectangle bounds) {
        WrapperRI im = new WrapperRI(ras);
        return RectIterFactory.create((RenderedImage)im, bounds);
    }

    public static WritableRectIter createWritable(WritableRenderedImage im, Rectangle bounds) {
        SampleModel sm;
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        if ((sm = im.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sm.getDataType()) {
                case 0: {
                    int[] offsets = ((ComponentSampleModel)sm).getBandOffsets();
                    if (offsets.length == 1 && offsets[0] == 0) {
                        return new WritableRectIterCSMByteIndexed(im, bounds);
                    }
                    return new WritableRectIterCSMByte((RenderedImage)im, bounds);
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    return new WritableRectIterCSMFloat((RenderedImage)im, bounds);
                }
            }
        }
        return new WritableRectIterFallback(im, bounds);
    }

    public static WritableRectIter createWritable(WritableRaster ras, Rectangle bounds) {
        WrapperWRI im = new WrapperWRI(ras);
        return RectIterFactory.createWritable((WritableRenderedImage)im, bounds);
    }
}

