/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.versioning;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sailimpl.omm.versioning.VersionOMM;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.util.log.ThreadLog;

public class VersioningRdbmsSail
extends RdfSchemaRepository
implements VersionManagement {
    protected ArrayList createdRepositories = new ArrayList();
    protected Connection adminConnection = null;
    protected int VersionUid;
    protected int baseUrlIndex;
    private static final String SUFFIX = "_HIST";
    protected static final String UPDATES_TABLE = "updates";
    protected static final String VERSION_TABLE = "version";
    protected static final String TRIPLES_HIST_TABLE = "triples_HIST";
    protected static final String BASEURL_TABLE = "baseurls";
    protected static final String EXPECTED_STATEMENTS_TABLE = "expected_sids";
    protected static final String ACTIVE_STATES_TABLE = "active";
    public static final String MADE_BY_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#madeBy";
    public static final String USER_ID_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#userID";
    public static final String VERSION_NAME_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#versionName";
    public static final String VERSION_UPDATE_ID = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#stateLabeled";
    public static final String BORN_AT_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#bornAt";
    public static final String DIED_AT_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#diedAt";
    public static final String MADE_ON_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#madeOn";
    public static final String EXPLICIT_KEY = "EXPLICIT";
    public static final String KIND_KEY = "KIND";

    protected void dropBranchedVersions() {
        if (this.adminConnection != null) {
            ThreadLog.trace((String)"adminConnection != null");
            Iterator iter = this.createdRepositories.iterator();
            try {
                Statement st = this.adminConnection.createStatement();
                while (iter.hasNext()) {
                    String branchedDatabaseName = (String)iter.next();
                    ThreadLog.trace((String)"branchedDatabaseName ");
                    try {
                        st.executeQuery("DROP DATABASE " + branchedDatabaseName);
                        ThreadLog.trace((String)"ok\n");
                    }
                    catch (SQLException ex) {
                        ThreadLog.trace((String)("false " + ex.getMessage() + "\n"));
                    }
                }
            }
            catch (SQLException e) {
                ThreadLog.trace((String)("SQLException " + e.getMessage() + "\n"));
            }
        }
        this.createdRepositories.clear();
    }

    public void shutDown() {
        ThreadLog.trace((String)"VersioningRdbmsSail ->shutDown(begin)");
        this.dropBranchedVersions();
        super.shutDown();
        ThreadLog.trace((String)"VersioningRdbmsSail ->shutDown(end)");
    }

    public void initialize(Map configParams) throws SailInitializationException {
        ThreadLog.trace((String)"initializing VersioningRdbmsSail");
        super.initialize(configParams);
        ThreadLog.trace((String)"VersioningRdbmsSail initialized");
    }

    protected void _initDatabase() throws SailInitializationException {
        try {
            super._initDatabase();
            this.createExpectedSIDSTable();
            this.createBaseUrlTable();
            this.createUpdatesTable();
            this.createTripleHIST_Table();
            this.createVersionTable();
            this.createActiveStatesTable();
        }
        catch (SQLException e) {
            throw new SailInitializationException(e);
        }
    }

    private String getSuffix(int state) {
        String result = "";
        result = result + "_" + state;
        return result;
    }

    protected RDBMS RDBMS() {
        return this._rdbms;
    }

    protected boolean createExpectedSIDSTable() throws SQLException {
        if (!this.RDBMS().tableExists(EXPECTED_STATEMENTS_TABLE)) {
            String tableQ = "CREATE TABLE expected_sids (sid " + this.RDBMS().ID_INT + " NOT NULL," + "found " + this.RDBMS().BOOLEAN + ")";
            this.RDBMS().executeUpdate(tableQ);
            return true;
        }
        return false;
    }

    protected boolean createBaseUrlTable() throws SQLException {
        if (!this.RDBMS().tableExists(BASEURL_TABLE)) {
            String tableQ = "CREATE TABLE baseurls (urlID " + this.RDBMS().ID_INT + " NOT NULL," + "url " + this.RDBMS().LOCALNAME + ")";
            this.RDBMS().executeUpdate(tableQ);
            return true;
        }
        return false;
    }

    protected boolean createUpdatesTable() throws SQLException {
        if (!this.RDBMS().tableExists(UPDATES_TABLE)) {
            String tableQ = "CREATE TABLE updates (uid " + this.RDBMS().ID_INT + " NOT NULL," + "time TIMESTAMP ," + "usid " + this.RDBMS().ID_INT + " ," + "kind " + this.RDBMS().BOOLEAN + " , " + "urlID " + this.RDBMS().ID_INT + ")";
            this.RDBMS().executeUpdate(tableQ);
            this.RDBMS().createIndex(UPDATES_TABLE, new String[]{"uid"}, true);
            return true;
        }
        return false;
    }

    protected boolean createTripleHIST_Table() throws SQLException {
        if (!this.RDBMS().tableExists(TRIPLES_HIST_TABLE)) {
            String tableQ = "CREATE TABLE triples_HIST (id " + this.RDBMS().ID_INT + " NOT NULL," + "subject " + this.RDBMS().ID_INT + " NOT NULL REFERENCES " + "resources" + "(id), " + "predicate " + this.RDBMS().ID_INT + " NOT NULL REFERENCES " + "resources" + "(id), " + "object " + this.RDBMS().ID_INT + " NOT NULL, " + "explicit " + this.RDBMS().BOOLEAN + " NOT NULL, " + "BornAt " + this.RDBMS().ID_INT + " , " + "DiedAt " + this.RDBMS().ID_INT + " )";
            this.RDBMS().executeUpdate(tableQ);
            this.RDBMS().createIndex(TRIPLES_HIST_TABLE, new String[]{"id"}, false);
            return true;
        }
        return false;
    }

    protected boolean createVersionTable() throws SQLException {
        if (!this.RDBMS().tableExists(VERSION_TABLE)) {
            String tableQ = "CREATE TABLE version (vid " + this.RDBMS().ID_INT + " NOT NULL," + "usid " + this.RDBMS().ID_INT + " , " + "uid " + this.RDBMS().ID_INT + " , " + "label VARCHAR(255) )";
            this.RDBMS().executeUpdate(tableQ);
            this.RDBMS().createIndex(VERSION_TABLE, new String[]{"vid"}, true);
            return true;
        }
        return false;
    }

    protected boolean createActiveStatesTable() throws SQLException {
        if (!this.RDBMS().tableExists(ACTIVE_STATES_TABLE)) {
            String tableQ = "CREATE TABLE active (uid " + this.RDBMS().ID_INT + " NOT NULL," + "refs " + this.RDBMS().ID_INT + " )";
            this.RDBMS().executeUpdate(tableQ);
            return true;
        }
        return false;
    }

    protected void _processChunkFromRemoveExpiredStatements(String idList) throws SQLException {
        this.RDBMS().executeUpdate("UPDATE triples_HIST SET DiedAt = " + (this.getStateUid() + 1) + " WHERE id IN " + idList);
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (SessionContext.getContext().updateMode != 1) {
            int subjId = this._getResourceId(subj);
            int predId = this._getURIId(pred);
            int objId = this._getValueId(obj);
            int statementId = 0;
            boolean hasRow = false;
            boolean bExplicit = false;
            try {
                Connection con = this.RDBMS().getConnection();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT id, explicit  FROM triples WHERE subject=" + subjId + " AND predicate=" + predId + " AND object=" + objId);
                if (rs.next()) {
                    statementId = rs.getInt(1);
                    bExplicit = rs.getString(2).equalsIgnoreCase(this.RDBMS().convertBoolean(true));
                    hasRow = true;
                }
                rs.close();
                st.close();
                con.close();
                if (hasRow) {
                    this.RDBMS().executeUpdate("UPDATE expected_sids SET found=1 WHERE sid = " + statementId);
                }
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        super.addStatement(subj, pred, obj);
    }

    public void clearRepository() throws SailUpdateException {
        super.clearRepository();
        try {
            this.RDBMS().executeUpdate("DROP TABLE updates");
            this.RDBMS().executeUpdate("DROP TABLE triples_HIST");
            this.RDBMS().executeUpdate("DROP TABLE version");
            this.RDBMS().executeUpdate("DROP TABLE baseurls");
            this.RDBMS().executeUpdate("DROP TABLE expected_sids");
            this.dropBranchedVersions();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void startTransaction() {
        String url;
        super.startTransaction();
        this.baseUrlIndex = 0;
        SessionContext sc = SessionContext.getContext();
        if (sc.updateMode != 1 && (url = sc.baseUrl).length() > 0) {
            try {
                Connection con = this.RDBMS().getConnection();
                Statement st = con.createStatement();
                System.out.println("CP=1");
                ResultSet rs = null;
                try {
                    rs = st.executeQuery("SELECT urlID FROM baseurls WHERE url = '" + this.RDBMS().escapeString(url) + "'");
                    if (rs.next()) {
                        this.baseUrlIndex = rs.getInt(1);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    throw new SailInternalException(e);
                }
                System.out.println("baseUrlIndex=" + this.baseUrlIndex);
                if (this.baseUrlIndex == 0) {
                    int max = 0;
                    rs = st.executeQuery("SELECT max(urlID) FROM baseurls");
                    if (rs.next()) {
                        max = rs.getInt(1);
                    }
                    rs.close();
                    this.baseUrlIndex = max + 1;
                    this.RDBMS().executeUpdate("INSERT INTO baseurls VALUES (" + this.baseUrlIndex + ", '" + this.RDBMS().escapeString(url) + "')");
                    System.out.println("max=" + this.baseUrlIndex);
                }
                this.RDBMS().executeUpdate(" TRUNCATE expected_sids");
                this.RDBMS().executeUpdate(" INSERT INTO expected_sids SELECT th.id, 0 FROM triples_HIST th  INNER JOIN updates u on th.BornAt = u.uid  WHERE u.urlID = " + this.baseUrlIndex + " AND th.DiedAt = 0 AND th.explicit = 1");
                st.close();
                con.close();
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        this.VersionUid = -1;
        this.VersionUid = this.getStateUid();
    }

    public void commitTransaction() {
        block5: {
            SessionContext sc = SessionContext.getContext();
            try {
                if (sc.updateMode != 2) break block5;
                Connection con = null;
                Statement st = null;
                ResultSet rs = null;
                try {
                    con = this.RDBMS().getConnection();
                    st = con.createStatement();
                    rs = st.executeQuery("SELECT sid FROM expected_sids WHERE found = 0");
                    while (rs.next()) {
                        int sid = rs.getInt(1);
                        if (0 >= this.RDBMS().executeUpdate("UPDATE triples SET explicit=" + this.RDBMS().FALSE + " WHERE id=" + sid)) continue;
                        this._statementsRemoved = true;
                    }
                    rs.close();
                    st.close();
                    con.close();
                }
                catch (SQLException e) {
                    throw new SailInternalException(e);
                }
                this.RDBMS().executeUpdate("TRUNCATE expected_sids");
            }
            catch (SQLException ex) {
                throw new SailInternalException(ex);
            }
        }
        super.commitTransaction();
        this.VersionUid = -1;
    }

    protected int getCurrentUserID() {
        SessionContext o = SessionContext.getContext();
        if (o == null) {
            throw new SailInternalException("null session context in getCurrentUserID()");
        }
        if (o.userID == 0) {
            o.userID = 2;
        }
        return o.userID;
    }

    protected int getStateUid() {
        SessionContext o = SessionContext.getContext();
        if (o == null) {
            throw new SailInternalException("null session context in getStateUid()");
        }
        this.VersionUid = o.VersionState;
        if (this.VersionUid <= 0) {
            try {
                Connection con = this.RDBMS().getConnection();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT max(uid) FROM updates");
                this.VersionUid = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                st.close();
                con.close();
            }
            catch (SQLException ex) {
                throw new SailInternalException(ex);
            }
        }
        return this.VersionUid;
    }

    public Iterator getUpdateIds() {
        return new Iterator(){
            Connection con = null;
            Statement st = null;
            ResultSet rs = null;
            boolean hn = false;
            {
                try {
                    this.con = VersioningRdbmsSail.this.RDBMS().getConnection();
                    this.st = this.con.createStatement();
                    this.rs = this.st.executeQuery("SELECT uid FROM updates");
                    this.hn = this.rs.next();
                    if (!this.hn) {
                        this.rs.close();
                        this.st.close();
                        this.con.close();
                    }
                }
                catch (SQLException ex) {
                    throw new SailInternalException(ex);
                }
            }

            public boolean hasNext() {
                return this.hn;
            }

            public Object next() {
                String res = null;
                if (this.hn) {
                    try {
                        res = this.rs.getString(1);
                        this.hn = this.rs.next();
                        if (!this.hn) {
                            this.rs.close();
                            this.st.close();
                            this.con.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new SailInternalException(ex);
                    }
                }
                return res;
            }

            public void remove() {
            }
        };
    }

    public Iterator getVersionIds() {
        return new Iterator(){
            Connection con = null;
            Statement st = null;
            ResultSet rs = null;
            boolean hn = false;
            {
                try {
                    this.con = VersioningRdbmsSail.this.RDBMS().getConnection();
                    this.st = this.con.createStatement();
                    this.rs = this.st.executeQuery("SELECT vid FROM version");
                    this.hn = this.rs.next();
                    if (!this.hn) {
                        this.rs.close();
                        this.st.close();
                        this.con.close();
                    }
                }
                catch (SQLException ex) {
                    throw new SailInternalException(ex);
                }
            }

            public boolean hasNext() {
                return this.hn;
            }

            public Object next() {
                String res = null;
                if (this.hn) {
                    try {
                        res = this.rs.getString(1);
                        this.hn = this.rs.next();
                        if (!this.hn) {
                            this.rs.close();
                            this.st.close();
                            this.con.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new SailInternalException(ex);
                    }
                }
                return res;
            }

            public void remove() {
            }
        };
    }

    public void labelState(long stateUID, String label) {
        int usid = this.getCurrentUserID();
        try {
            Connection con = this.RDBMS().getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("select max(vid) from version");
            int maxvid = 0;
            if (rs.next()) {
                maxvid = rs.getInt(1);
            }
            rs.close();
            if (label == null || label.length() == 0) {
                label = "New label " + (maxvid + 1);
            }
            st.executeUpdate("insert into version VALUES (" + (maxvid + 1) + " , " + usid + ", " + stateUID + " ," + " '" + label + "')");
            st.close();
            con.close();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void labelCurrentState(String label) {
        int saveState = this.VersionUid;
        this.VersionUid = -1;
        int stateUID = this.getStateUid();
        this.VersionUid = saveState;
        this.labelState(stateUID, label);
    }

    public void revertToState(long stateUID) {
        throw new RuntimeException("revertToState is not implemented");
    }

    protected String alias() {
        return super.getClass().getSuperclass().getName();
    }

    public void workWithState(long stateUID) {
        int refs;
        ResultSet rs;
        Statement st;
        Connection con;
        SessionContext sc = SessionContext.getContext();
        int vs = sc.VersionState;
        if (vs > 0) {
            try {
                con = this.RDBMS().getConnection();
                st = con.createStatement();
                rs = st.executeQuery("SELECT refs FROM active WHERE uid =" + vs);
                boolean toRemove = false;
                if (rs.next() && (refs = rs.getInt(1)) == 1) {
                    toRemove = true;
                }
                rs.close();
                st.close();
                con.close();
                if (!toRemove) {
                    this.RDBMS().executeUpdate("UPDATE active SET refs=refs-1 WHERE uid=" + vs);
                } else {
                    this.RDBMS().executeUpdate("DELETE FROM active WHERE uid=" + vs);
                }
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        if (stateUID > 0L) {
            try {
                con = this.RDBMS().getConnection();
                st = con.createStatement();
                rs = st.executeQuery("SELECT refs FROM active WHERE uid =" + stateUID);
                boolean toInsert = true;
                if (rs.next()) {
                    refs = rs.getInt(1);
                    toInsert = false;
                }
                rs.close();
                if (!toInsert) {
                    this.RDBMS().executeUpdate("UPDATE active SET refs=refs+1 WHERE uid=" + stateUID);
                } else {
                    this.RDBMS().executeUpdate("INSERT INTO active VALUES ( " + stateUID + " , " + 1 + ")");
                    this.branchState(stateUID);
                }
                st.close();
                con.close();
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
    }

    public String branchState(long stateUID) {
        String result = "";
        SessionContext sc = SessionContext.getContext();
        try {
            SystemConfig sysConfig = SesameServer.getSystemConfig();
            String branchId = sc.repository + "branch_" + this.getSuffix((int)stateUID);
            RepositoryConfig rc = sysConfig.cloneRepository(sc.repository, branchId);
            rc.setTitle("branch of " + this.getSuffix((int)stateUID) + " " + rc.getTitle());
            sc.repository = branchId;
            boolean b_do_not_append_data = false;
            boolean b_do_not_create_data = true;
            Iterator iter = rc.getSailList().iterator();
            while (iter.hasNext()) {
                String url;
                SailConfig sailConfig = (SailConfig)iter.next();
                String param = sailConfig.getSailClass();
                if (param.equals(this.getClass().getName())) {
                    sailConfig.setSailClass(this.alias());
                }
                if ((url = sailConfig.getParameter("jdbcUrl")) == null) continue;
                int pos = url.lastIndexOf(47);
                String repdb = url.substring(pos + 1);
                repdb = repdb + this.getSuffix((int)stateUID) + "branch";
                url = url.substring(0, pos + 1);
                sailConfig.setParameter("jdbcUrl", url + repdb);
                String user = sailConfig.getParameter("user");
                String pass = sailConfig.getParameter("password");
                Connection c1 = null;
                try {
                    c1 = DriverManager.getConnection(url + repdb, user, pass);
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                if (c1 != null) {
                    c1.close();
                    b_do_not_append_data = b_do_not_create_data;
                    break;
                }
                if (!b_do_not_create_data) continue;
                if (this.adminConnection == null) {
                    this.adminConnection = DriverManager.getConnection(url, user, pass);
                }
                Statement st2 = this.adminConnection.createStatement();
                try {
                    st2.execute("DROP DATABASE " + repdb);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                st2.execute("CREATE DATABASE " + repdb);
                this.createdRepositories.add(repdb);
                st2.close();
                b_do_not_create_data = false;
            }
            UserInfo uiAdmin = sysConfig.getUserInfo(1);
            uiAdmin.addReadWriteAccess(rc);
            if (!b_do_not_append_data) {
                ThreadLog.trace((String)"branch begin");
                LocalService service = SesameServer.getLocalService();
                service.login(uiAdmin.getLogin(), uiAdmin.getPassword());
                LocalRepository rep = (LocalRepository)service.getRepository(rc.getRepositoryId());
                Sail otherSail = rep.getSail();
                ThreadLog.trace((String)"branch end");
                Connection con = this.RDBMS().getConnection();
                Statement st = con.createStatement();
                ResultSet rs = null;
                if (otherSail != null) {
                    URIImpl pred;
                    Object subj;
                    String nsString;
                    int old_id = sc.userID;
                    sc.userID = 1;
                    rs = st.executeQuery("SELECT n1.name, r1.localname,n2.name, r2.localname, n3.name, r3.localname FROM triples_HIST th ,resources r1, namespaces n1, resources r2, namespaces n2, resources r3, namespaces n3  WHERE th.explicit=" + this.RDBMS().TRUE + " AND th.BornAt <= " + stateUID + " AND (th.DiedAt > " + stateUID + " OR th.DiedAt = 0)" + " AND r1.id=th.subject" + " AND r2.id=th.predicate" + " AND r3.id=th.object" + " AND r1.namespace =n1.id" + " AND r2.namespace =n2.id" + " AND r3.namespace =n3.id");
                    ((RdfRepository)otherSail).startTransaction();
                    while (rs.next()) {
                        nsString = rs.getString(1);
                        subj = null;
                        subj = nsString == null || 0 == nsString.compareToIgnoreCase("NULL") ? new BNodeImpl(rs.getString(2)) : new URIImpl(nsString, rs.getString(2));
                        pred = new URIImpl(rs.getString(3), rs.getString(4));
                        Object obj = null;
                        String valString = rs.getString(5);
                        obj = valString == null || 0 == valString.compareToIgnoreCase("NULL") ? new BNodeImpl(rs.getString(6)) : new URIImpl(valString, rs.getString(6));
                        try {
                            ((RdfRepository)otherSail).addStatement((Resource)subj, (URI)pred, (Value)obj);
                        }
                        catch (SailUpdateException e) {
                            throw new SailInternalException(e);
                        }
                    }
                    rs.close();
                    rs = st.executeQuery("SELECT n1.name, r1.localname,n2.name, r2.localname, l1.label, l1.language FROM triples_HIST th ,resources r1, namespaces n1, resources r2, namespaces n2, literals l1  WHERE th.explicit=" + this.RDBMS().TRUE + " AND th.BornAt <= " + stateUID + " AND (th.DiedAt > " + stateUID + " OR th.DiedAt = 0)" + " AND r1.id = th.subject" + " AND r2.id = th.predicate" + " AND l1.id = th.object" + " AND r1.namespace =n1.id" + " AND r2.namespace =n2.id");
                    while (rs.next()) {
                        nsString = rs.getString(1);
                        subj = null;
                        subj = nsString == null || 0 == nsString.compareToIgnoreCase("NULL") ? new BNodeImpl(rs.getString(2)) : new URIImpl(nsString, rs.getString(2));
                        pred = new URIImpl(rs.getString(3), rs.getString(4));
                        String val = rs.getString(5);
                        String lang = rs.getString(6);
                        LiteralImpl obj = new LiteralImpl(val, lang);
                        try {
                            ((RdfRepository)otherSail).addStatement((Resource)subj, (URI)pred, (Value)obj);
                        }
                        catch (SailUpdateException e) {
                            throw new SailInternalException(e);
                        }
                    }
                    rs.close();
                    ((RdfRepository)otherSail).commitTransaction();
                    NamespaceIterator nsIter = this.getNamespaces();
                    while (nsIter.hasNext()) {
                        nsIter.next();
                        try {
                            ((RdfRepository)otherSail).changeNamespacePrefix(nsIter.getName(), nsIter.getPrefix());
                        }
                        catch (SailUpdateException e) {
                            ThreadLog.warning((String)("Unable to set namespace prefix '" + nsIter.getPrefix() + "' for namespace '" + nsIter.getName() + "': " + e.getMessage()));
                        }
                    }
                    sc.userID = old_id;
                }
                st.close();
                con.close();
            }
            sc.repository = rc.getRepositoryId();
            result = rc.getRepositoryId();
        }
        catch (ConfigurationException e) {
            throw new SailInternalException(e);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        catch (AccessDeniedException e) {
            throw new SailInternalException(e);
        }
        catch (UnknownRepositoryException e) {
            throw new SailInternalException(e);
        }
        return result;
    }

    public Iterator getVersions() {
        return new Iterator(){
            Connection con = null;
            Statement st = null;
            ResultSet rs = null;
            boolean hn = false;
            {
                try {
                    this.con = VersioningRdbmsSail.this.RDBMS().getConnection();
                    this.st = this.con.createStatement();
                    this.rs = this.st.executeQuery("SELECT vid, usid, uid, label FROM version");
                    this.hn = this.rs.next();
                    if (!this.hn) {
                        this.rs.close();
                        this.st.close();
                        this.con.close();
                    }
                }
                catch (SQLException ex) {
                    throw new SailInternalException(ex);
                }
            }

            public boolean hasNext() {
                return this.hn;
            }

            public Object next() {
                VersionOMM res = null;
                if (this.hn) {
                    try {
                        int vid = this.rs.getInt(1);
                        int usid = this.rs.getInt(2);
                        int uid = this.rs.getInt(3);
                        String label = this.rs.getString(4);
                        res = new VersionOMM(vid, usid, uid, label);
                        this.hn = this.rs.next();
                        if (!this.hn) {
                            this.rs.close();
                            this.st.close();
                            this.con.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new SailInternalException(ex);
                    }
                }
                return res;
            }

            public void remove() {
            }
        };
    }

    public void lockStatements(Iterator statementsList) {
        throw new RuntimeException("lockStatements is not implemented");
    }

    public void unlockStatements(Iterator statementsList) {
        throw new RuntimeException("unlockStatements is not implemented");
    }

    public void pauseCounterIncrement() {
        SessionContext.getContext().bIncrementIsPaused = true;
    }

    public void continueCounterIncrement() {
        SessionContext.getContext().bIncrementIsPaused = false;
    }

    public boolean isPausedCounterIncrement() {
        return SessionContext.getContext().bIncrementIsPaused;
    }

    public Map getMetaInfo(String subj, String pred, String obj) {
        if (subj == null || pred == null || obj == null) {
            throw new SailInternalException("Cannot Retrieve MetaInfo for a statement that is not in the repository:\n<" + subj + "," + pred + "," + obj + ">");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        URIImpl subjRes = new URIImpl(subj);
        URIImpl predRes = new URIImpl(pred);
        URIImpl objRes = null;
        try {
            objRes = new URIImpl(obj);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        int subjId = this._getResourceId((Resource)subjRes);
        int predId = this._getResourceId((Resource)predRes);
        int objId = 0;
        if (objRes != null) {
            objId = this._getResourceId((Resource)objRes);
        }
        if (objId == 0) {
            LiteralImpl objLit = new LiteralImpl(obj);
            objId = this._getLiteralId((Literal)objLit);
        }
        if (subjId == 0 || objId == 0 || predId == 0) {
            throw new SailInternalException("Cannot Retrieve MetaInfo for a statement that is not in the repository:\n<" + subj + "," + pred + "," + obj + ">");
        }
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.RDBMS().getConnection();
            st = con.createStatement();
            rs = st.executeQuery("SELECT id, explicit, BornAt, DiedAt FROM triples_HIST WHERE subject=" + subjId + " AND predicate=" + predId + " AND object=" + objId);
            int countLifetime = 0;
            while (rs.next()) {
                String suffix = "";
                if (countLifetime > 0) {
                    suffix = suffix + countLifetime;
                }
                int statementId = rs.getInt(1);
                boolean explicit = rs.getBoolean(2);
                int bornAt = rs.getInt(3);
                int diedAt = rs.getInt(4);
                map.put(EXPLICIT_KEY + suffix, explicit ? "true" : "false");
                map.put(BORN_AT_URI + suffix, new Integer(bornAt));
                if (diedAt != 0) {
                    map.put(DIED_AT_URI + suffix, new Integer(diedAt));
                }
                ++countLifetime;
            }
            rs.close();
            st.close();
            con.close();
        }
        catch (SQLException ex) {
            throw new SailInternalException(ex);
        }
        return map;
    }

    public Map getUpdateMetaInfo(String updateId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.RDBMS().getConnection();
            st = con.createStatement();
            rs = st.executeQuery("SELECT uid, time, usid, kind FROM updates WHERE uid = " + updateId);
            if (rs.next()) {
                String time = rs.getString(2);
                int usid = rs.getInt(3);
                int kind = rs.getInt(4);
                UserInfo ui = SesameServer.getSystemConfig().getUserInfo(usid);
                if (ui != null) {
                    map.put(MADE_BY_URI, ui.getFullName());
                } else {
                    map.put(MADE_BY_URI, "unknown user");
                }
                map.put(USER_ID_URI, new Integer(usid));
                map.put(MADE_ON_URI, time);
                String updateKind = "";
                switch (kind) {
                    case 1: {
                        updateKind = "add";
                        break;
                    }
                    case 2: {
                        updateKind = "remove";
                        break;
                    }
                    case 3: {
                        updateKind = "add/remove";
                        break;
                    }
                    default: {
                        updateKind = "UNKNOWN/BUG";
                    }
                }
                map.put(KIND_KEY, updateKind);
            }
            rs.close();
            st.close();
            con.close();
        }
        catch (SQLException ex) {
            throw new SailInternalException(ex);
        }
        return map;
    }

    public Map getVersionMetaInfo(String versionId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.RDBMS().getConnection();
            st = con.createStatement();
            rs = st.executeQuery("SELECT vid, usid, uid, label FROM version WHERE vid = " + versionId);
            if (rs.next()) {
                int vid = rs.getInt(1);
                int usid = rs.getInt(2);
                int uid = rs.getInt(3);
                String label = rs.getString(4);
                UserInfo ui = SesameServer.getSystemConfig().getUserInfo(usid);
                map.put(USER_ID_URI, new Long(uid));
                if (ui != null) {
                    map.put(MADE_BY_URI, ui.getFullName());
                } else {
                    map.put(MADE_BY_URI, "unknown user");
                }
                map.put(VERSION_UPDATE_ID, new Integer(uid));
                map.put(VERSION_NAME_URI, label);
            }
            rs.close();
            st.close();
            con.close();
        }
        catch (SQLException ex) {
            throw new SailInternalException(ex);
        }
        return map;
    }

    protected void _processChangedTriples() throws SQLException {
        try {
            if ((this._statementsAdded || this._statementsRemoved) && !this.isPausedCounterIncrement()) {
                int updateKind = 0;
                if (this._statementsAdded) {
                    ++updateKind;
                }
                if (this._statementsRemoved) {
                    updateKind += 2;
                }
                this.RDBMS().executeUpdate("INSERT into updates VALUES(" + (this.getStateUid() + 1) + ", NULL, " + this.getCurrentUserID() + ", " + updateKind + " , " + this.baseUrlIndex + ")");
                if (this.getStateUid() == 1) {
                    this.labelCurrentState("Auto Version after the first Upload");
                }
            }
            this.RDBMS().executeUpdate(" INSERT INTO triples_HIST SELECT  t.id, t.subject, t.predicate, t.object, " + this.RDBMS().TRUE + ", " + this.getStateUid() + ", " + 0 + " from " + "newtriples" + " t");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        super._processChangedTriples();
    }
}

