/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model.iterators;

import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public abstract class NestedResourceIterator
implements ResourceIterator {
    protected ValueIterator _outerIter;
    protected ResourceIterator _innerIter;

    public NestedResourceIterator(ValueIterator outerIter) {
        this._outerIter = outerIter;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this._innerIter == null || !this._innerIter.hasNext()) {
            while (this._outerIter.hasNext()) {
                Value outerValue = this._outerIter.next();
                this._innerIter = this.getInnerIterator(outerValue);
                if (!this._innerIter.hasNext()) continue;
            }
        }
        return this._innerIter != null && this._innerIter.hasNext();
    }

    public Value next() throws QueryEvaluationException {
        if (this.hasNext()) {
            return this._innerIter.next();
        }
        throw new NoSuchElementException();
    }

    public Resource nextResource() throws QueryEvaluationException {
        return (Resource)this.next();
    }

    public abstract ResourceIterator getInnerIterator(Value var1);

    public void close() {
        if (this._outerIter != null) {
            this._outerIter.close();
            this._outerIter = null;
        }
        if (this._innerIter != null) {
            this._innerIter.close();
            this._innerIter = null;
        }
    }

    protected void finalize() {
        this.close();
    }
}

