/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql;

import java.io.IOException;
import java.io.StringReader;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.RqlOptimizer;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.parser.ParseException;
import org.openrdf.sesame.query.rql.parser.RqlParser;
import org.openrdf.sesame.query.rql.parser.TokenMgrError;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.util.StringUtil;

public class RqlEngine {
    protected RdfSchemaSource _rss;

    public RqlEngine(RdfSchemaSource rss) {
        if (rss == null) {
            throw new IllegalArgumentException("rss must not be nul");
        }
        this._rss = rss;
    }

    public void evaluateQuery(Query query, TableQueryResultListener resList) throws IOException, QueryEvaluationException {
        if ((query = RqlOptimizer.optimize(query)) instanceof ResourceQuery) {
            ResourceQuery resourceQuery = (ResourceQuery)query;
            resourceQuery.evaluate(this._rss, resList);
        } else if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            boolean result = booleanQuery.isTrue(this._rss);
            resList.startTableQueryResult();
            resList.startTuple();
            resList.tupleValue((Value)new LiteralImpl(String.valueOf(result)));
            resList.endTuple();
            resList.endTableQueryResult();
        }
    }

    public Query parseQuery(String rqlQuery) throws MalformedQueryException {
        rqlQuery = this._swapUsingNamespace(rqlQuery);
        RqlParser rqlParser = new RqlParser(new StringReader(rqlQuery));
        try {
            return rqlParser.parse();
        }
        catch (TokenMgrError tme) {
            throw new MalformedQueryException(tme.getMessage());
        }
        catch (ParseException pe) {
            throw new MalformedQueryException(pe);
        }
    }

    private String _swapUsingNamespace(String query) {
        String result;
        String queryLC = query.toLowerCase();
        int usingIdx = StringUtil.lastIndexOfWord((String)queryLC, (String)"using");
        if (usingIdx != -1) {
            String part1 = query.substring(0, usingIdx);
            String part2 = query.substring(usingIdx);
            result = part2 + "\n" + part1;
        } else {
            result = query;
        }
        return result;
    }
}

