/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rdql.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.query.rdql.parser.JavaCharStream;
import org.openrdf.sesame.query.rdql.parser.ParseException;
import org.openrdf.sesame.query.rdql.parser.RdqlParserConstants;
import org.openrdf.sesame.query.rdql.parser.RdqlParserTokenManager;
import org.openrdf.sesame.query.rdql.parser.Token;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanConstant;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.Like;
import org.openrdf.sesame.sail.query.LiteralExpr;
import org.openrdf.sesame.sail.query.MathExpr;
import org.openrdf.sesame.sail.query.Not;
import org.openrdf.sesame.sail.query.Null;
import org.openrdf.sesame.sail.query.Or;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.ResourceExpr;
import org.openrdf.sesame.sail.query.SelectQuery;
import org.openrdf.sesame.sail.query.StringCompare;
import org.openrdf.sesame.sail.query.StringConstant;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class RdqlParser
implements RdqlParserConstants {
    public static final URI XSD_INTEGER = new URIImpl("http://www.w3.org/2001/XMLSchema#integer");
    public static final URI XSD_FLOAT = new URIImpl("http://www.w3.org/2001/XMLSchema#float");
    protected Map _namespaces = new HashMap(16);
    protected List _sharedVars = new ArrayList(16);
    protected int _varNo = 0;
    public RdqlParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[29];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    protected void _setNamespacePrefix(String prefix, String namespace) throws ParseException {
        if (this._namespaces.containsKey(prefix)) {
            throw new ParseException("Prefix \"" + prefix + "\" already in use.");
        }
        this._namespaces.put(prefix, namespace);
    }

    protected String _getNamespace(String prefix) {
        String result = (String)this._namespaces.get(prefix);
        if (result == null) {
            if ("rdf".equals(prefix)) {
                result = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            } else if ("rdfs".equals(prefix)) {
                result = "http://www.w3.org/2000/01/rdf-schema#";
            } else if ("xsd".equals(prefix)) {
                result = "http://www.w3.org/2001/XMLSchema#";
            } else if ("owl".equals(prefix)) {
                result = "http://www.w3.org/2002/07/owl#";
            }
        }
        return result;
    }

    protected Var _getSharedVar(String varName) {
        Var var;
        Iterator i = this._sharedVars.iterator();
        while (i.hasNext()) {
            var = (Var)i.next();
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        var = new Var(varName);
        this._sharedVars.add(var);
        return var;
    }

    protected Var _createAnonymousVar() {
        Var result = new Var("_" + this._varNo++);
        result.setAnonymous(true);
        return result;
    }

    protected URI _parseURI(String uri) throws ParseException {
        if (uri.startsWith("<")) {
            return this._parseQuotedURI(uri);
        }
        return this._parseQName(uri);
    }

    protected URI _parseQuotedURI(String uri) throws ParseException {
        try {
            uri = uri.substring(1, uri.length() - 1);
            int colonIdx = uri.indexOf(58);
            if (colonIdx > 0) {
                String prefix = uri.substring(0, colonIdx);
                String localName = uri.substring(colonIdx + 1);
                String namespace = this._getNamespace(prefix);
                if (namespace != null) {
                    uri = namespace + localName;
                }
            }
            return new URIImpl(uri);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
    }

    protected URI _parseQName(String uri) throws ParseException {
        int colonIdx = uri.indexOf(58);
        String prefix = uri.substring(0, colonIdx);
        String localName = uri.substring(colonIdx + 1);
        String namespace = this._getNamespace(prefix);
        if (namespace == null) {
            throw new ParseException("Prefix \"" + prefix + "\" not defined.");
        }
        return new URIImpl(namespace + localName);
    }

    protected Literal _parseLiteral(String literal) throws ParseException {
        int endLabelIdx = this._findEndOfLabel(literal);
        int startLangIdx = literal.indexOf("@", endLabelIdx);
        int startDtIdx = literal.indexOf("^^", Math.max(endLabelIdx, startLangIdx));
        String label = literal.substring(1, endLabelIdx);
        label = NTriplesUtil.unescapeString((String)label);
        if (startLangIdx != -1) {
            String language = literal.substring(startLangIdx + 1);
            return new LiteralImpl(label, language);
        }
        if (startDtIdx != -1) {
            String dtString = literal.substring(startDtIdx + 2);
            URI datatype = this._parseURI(dtString);
            if (XmlDatatypeUtil.isBuiltInDatatype((String)datatype.getURI())) {
                try {
                    label = XmlDatatypeUtil.normalize((String)label, (String)datatype.getURI());
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            return new LiteralImpl(label, datatype);
        }
        return new LiteralImpl(label);
    }

    private int _findEndOfLabel(String literal) throws ParseException {
        boolean previousWasBackslash = false;
        for (int i = 1; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        throw new ParseException("Could not find end of literal label");
    }

    protected ParseException _createParseException(Token currentTokenVal, String[] tokenImage) {
        int length = tokenImage.length;
        String[] newTokenImage = new String[length + 1];
        newTokenImage[0] = "<EOF>";
        for (int i = 0; i < length; ++i) {
            newTokenImage[i + 1] = tokenImage[i];
        }
        int[][] expectedTokenSequences = new int[1][length];
        for (int i = 0; i < length; ++i) {
            expectedTokenSequences[0][i] = i + 1;
        }
        return new ParseException(currentTokenVal, expectedTokenSequences, newTokenImage);
    }

    public final TableQuery parseQuery() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.prefixes_clause();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        Query qc = this.select_query();
        this.jj_consume_token(0);
        return new TableQuery(qc);
    }

    public final void comma_opt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
    }

    public final void prefixes_clause() throws ParseException {
        this.jj_consume_token(37);
        this.prefix_decl();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.comma_opt();
            this.prefix_decl();
        }
    }

    public final void prefix_decl() throws ParseException {
        Token prefixToken = this.jj_consume_token(59);
        this.jj_consume_token(38);
        ResourceExpr uri = this.quoted_uri();
        String prefix = prefixToken.image;
        this._setNamespacePrefix(prefix, uri.getString());
    }

    public final Query select_query() throws ParseException {
        GraphPattern graphPattern = new GraphPattern();
        this.jj_consume_token(32);
        ArrayList<ProjectionElem> projection = this.projection();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 34: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        break;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(56);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 26: 
                        case 56: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.comma_opt();
                    this.jj_consume_token(56);
                }
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.jj_consume_token(35);
        this.triple_pattern_clause(graphPattern);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                this.constraint_clause(graphPattern);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        if (projection == null) {
            projection = new ArrayList<ProjectionElem>(this._sharedVars.size());
            for (int i = 0; i < this._sharedVars.size(); ++i) {
                Var var = (Var)this._sharedVars.get(i);
                projection.add(new ProjectionElem(var, null));
            }
        }
        if (projection.isEmpty()) {
            throw new ParseException("Select clause does not contain any variables.");
        }
        return new SelectQuery(projection, graphPattern);
    }

    public final List projection() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                return null;
            }
            case 58: {
                ArrayList<ProjectionElem> projection = new ArrayList<ProjectionElem>(16);
                Var var = this.var();
                projection.add(new ProjectionElem(var));
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 26: 
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.comma_opt();
                    var = this.var();
                    projection.add(new ProjectionElem(var));
                }
                return projection;
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ProjectionElem projection_elem() throws ParseException {
        Var var = this.var();
        return new ProjectionElem(var);
    }

    public final void triple_pattern_clause(GraphPattern graphPattern) throws ParseException {
        this.triple_pattern(graphPattern);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.comma_opt();
            this.triple_pattern(graphPattern);
        }
    }

    public final void triple_pattern(GraphPattern graphPattern) throws ParseException {
        Var objectVar;
        Var predicateVar;
        Var subjectVar;
        this.jj_consume_token(28);
        ValueExpr subject = this.var_or_uri();
        this.comma_opt();
        ValueExpr predicate = this.var_or_uri();
        this.comma_opt();
        ValueExpr object = this.var_or_const();
        this.jj_consume_token(29);
        if (subject instanceof Var) {
            subjectVar = (Var)subject;
        } else {
            subjectVar = this._createAnonymousVar();
            subjectVar.setValue(subject.getValue());
        }
        if (predicate instanceof Var) {
            predicateVar = (Var)predicate;
        } else {
            predicateVar = this._createAnonymousVar();
            predicateVar.setValue(predicate.getValue());
        }
        if (object instanceof Var) {
            objectVar = (Var)object;
        } else {
            objectVar = this._createAnonymousVar();
            objectVar.setValue(object.getValue());
        }
        graphPattern.add(new TriplePattern(subjectVar, predicateVar, objectVar));
    }

    public final void constraint_clause(GraphPattern graphPattern) throws ParseException {
        BooleanExpr boolExpr = this.boolean_expr();
        graphPattern.addConstraint(boolExpr);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    this.jj_consume_token(26);
                    break;
                }
                case 36: {
                    this.jj_consume_token(36);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            boolExpr = this.boolean_expr();
            graphPattern.addConstraint(boolExpr);
        }
    }

    public final BooleanExpr boolean_expr() throws ParseException {
        BooleanExpr result = this.conditional_and_expr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(16);
            BooleanExpr tmpExpr = this.conditional_and_expr();
            result = new Or(result, tmpExpr);
        }
        return result;
    }

    public final BooleanExpr conditional_and_expr() throws ParseException {
        BooleanExpr result = this.boolean_elem();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(17);
            BooleanExpr tmpExpr = this.boolean_elem();
            result = new And(result, tmpExpr);
        }
        return result;
    }

    public final BooleanExpr boolean_elem() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                return BooleanConstant.TRUE;
            }
            case 42: {
                this.jj_consume_token(42);
                return BooleanConstant.FALSE;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        if (this.jj_2_1(5)) {
            this.jj_consume_token(28);
            BooleanExpr expr = this.boolean_expr();
            this.jj_consume_token(29);
            return expr;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                BooleanExpr expr = this.boolean_elem();
                return new Not(expr);
            }
            case 18: 
            case 19: 
            case 28: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 67: 
            case 68: {
                ValueExpr leftValue = this.value_expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: 
                    case 40: {
                        int op = this.string_compare_operator();
                        ValueExpr rightValue = this.value_expr();
                        return new StringCompare(leftValue, rightValue, op);
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        int op = this.value_compare_operator();
                        ValueExpr rightValue = this.value_expr();
                        return new ValueCompare(leftValue, rightValue, op);
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        String pattern = this.string();
                        return new Like(leftValue, new StringConstant(pattern), true);
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        String pattern = this.string();
                        return new Not(new Like(leftValue, new StringConstant(pattern), true));
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int string_compare_operator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                return 1;
            }
            case 40: {
                this.jj_consume_token(40);
                return 2;
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int value_compare_operator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                return 1;
            }
            case 9: {
                this.jj_consume_token(9);
                return 2;
            }
            case 10: {
                this.jj_consume_token(10);
                return 3;
            }
            case 11: {
                this.jj_consume_token(11);
                return 4;
            }
            case 12: {
                this.jj_consume_token(12);
                return 5;
            }
            case 13: {
                this.jj_consume_token(13);
                return 6;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr value_expr() throws ParseException {
        ValueExpr result = this.additive_expr();
        return result;
    }

    public final ValueExpr additive_expr() throws ParseException {
        ValueExpr result = this.multiplicative_expr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            int op = this.additive_operator();
            ValueExpr tmpExpr = this.multiplicative_expr();
            result = new MathExpr(result, tmpExpr, op);
        }
        return result;
    }

    public final int additive_operator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                return 0;
            }
            case 19: {
                this.jj_consume_token(19);
                return 1;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr multiplicative_expr() throws ParseException {
        ValueExpr result = this.unary_expr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            int op = this.multiplicative_operator();
            ValueExpr tmpExpr = this.unary_expr();
            result = new MathExpr(result, tmpExpr, op);
        }
        return result;
    }

    public final int multiplicative_operator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                return 2;
            }
            case 21: {
                this.jj_consume_token(21);
                return 3;
            }
            case 22: {
                this.jj_consume_token(22);
                return 4;
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr unary_expr() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 67: 
            case 68: {
                ValueExpr result = this.var_or_const();
                return result;
            }
            case 18: {
                this.jj_consume_token(18);
                ValueExpr result = this.unary_expr();
                return result;
            }
            case 19: {
                this.jj_consume_token(19);
                ValueExpr result = this.unary_expr();
                return new MathExpr(new LiteralExpr((Literal)new LiteralImpl("-1", XSD_INTEGER)), result, 2);
            }
            case 28: {
                this.jj_consume_token(28);
                ValueExpr result = this.unary_expr();
                this.jj_consume_token(29);
                return result;
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr var_or_uri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                Var result = this.var();
                return result;
            }
            case 56: 
            case 57: {
                ResourceExpr result = this.uri();
                return result;
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr var_or_const() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                Var result = this.var();
                return result;
            }
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 67: 
            case 68: {
                ValueExpr result = this.value();
                return result;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Var var() throws ParseException {
        Token varToken = this.jj_consume_token(58);
        String varName = varToken.image.substring(1);
        return this._getSharedVar(varName);
    }

    public final ValueExpr value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 57: {
                ResourceExpr result = this.uri();
                return result;
            }
            case 44: 
            case 67: 
            case 68: {
                LiteralExpr result = this.literal();
                return result;
            }
            case 43: {
                Null result = this._null();
                return result;
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResourceExpr uri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                ResourceExpr expr = this.quoted_uri();
                return expr;
            }
            case 57: {
                ResourceExpr expr = this.qname();
                return expr;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResourceExpr quoted_uri() throws ParseException {
        Token uriToken = this.jj_consume_token(56);
        URI uri = this._parseQuotedURI(uriToken.image);
        return new ResourceExpr((Resource)uri);
    }

    public final ResourceExpr qname() throws ParseException {
        Token uriToken = this.jj_consume_token(57);
        URI uri = this._parseQName(uriToken.image);
        return new ResourceExpr((Resource)uri);
    }

    public final LiteralExpr literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                Token token = this.jj_consume_token(44);
                return new LiteralExpr(this._parseLiteral(token.image));
            }
            case 67: {
                Token token = this.jj_consume_token(67);
                return new LiteralExpr((Literal)new LiteralImpl(XmlDatatypeUtil.normalizeInteger((String)token.image), XSD_INTEGER));
            }
            case 68: {
                Token token = this.jj_consume_token(68);
                return new LiteralExpr((Literal)new LiteralImpl(XmlDatatypeUtil.normalizeFloat((String)token.image), XSD_FLOAT));
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string() throws ParseException {
        Token token;
        try {
            token = this.jj_consume_token(44);
        }
        catch (ParseException e) {
            throw this._createParseException(e.currentToken, new String[]{"<STRING>"});
        }
        Literal literal = this._parseLiteral(token.image);
        if (literal.getLanguage() != null || literal.getDatatype() != null) {
            throw new ParseException("Expected <STRING>, found <TEXT_LITERAL>: " + literal.toString());
        }
        return literal.getLabel();
    }

    public final Null _null() throws ParseException {
        this.jj_consume_token(43);
        return new Null();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3R_67() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_49() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_51()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_21() {
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_45()) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(43);
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_61();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_28() {
        Token xsp;
        if (this.jj_3R_38()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_39());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_58()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_18() {
        if (this.jj_3R_19()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_23()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_47() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_46() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_47()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_54() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_29() {
        if (this.jj_3R_40()) {
            return true;
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(42);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_16()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_1()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_17()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_18()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(41);
    }

    private final boolean jj_3R_24() {
        Token xsp;
        if (this.jj_3R_28()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_64() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_65()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_66()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token xsp;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_14());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_35() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_34() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_33() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_37()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(40);
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_30() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_68() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_23() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_43()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_44()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_10() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_12());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_51() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_50() {
        return this.jj_scan_token(21);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0x4000000, 0x4000000, 0, 0x4000000, 0, 0, 0x4000000, 0x100000, 0x14000000, 0x4000000, 0x4000000, 65536, 131072, 25181952, 0, 269238272, 0, 16128, 786432, 786432, 0x700000, 0x700000, 0x100C0000, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{32, 0, 0x8000000, 6, 0x1000000, 6, 16, 0x4000000, 0x4000000, 0, 16, 16, 0, 0, 384, 1536, 117446656, 384, 0, 0, 0, 0, 0, 117446656, 0x7000000, 117446656, 50337792, 0x3000000, 4096};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 24, 0, 24, 24, 0, 24};
    }

    public RdqlParser(InputStream stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new RdqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RdqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new RdqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RdqlParser(RdqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(RdqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[69];
        for (i = 0; i < 69; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 29; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 69; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        RdqlParser.jj_la1_0();
        RdqlParser.jj_la1_1();
        RdqlParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

