/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.OutputSchema;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.util.Xml;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.AddElemValue;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.getrecords.FieldMapper;
import org.fao.geonet.kernel.csw.services.getrecords.SearchController;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.locationtech.jts.util.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CswService.Transaction")
public class Transaction
extends AbstractOperation
implements CatalogService {
    static final String NAME = "Transaction";
    @Autowired
    SchemaManager _schemaManager;
    private SearchController _searchController;
    @Autowired
    private FieldMapper _fieldMapper;
    @Autowired
    IMetadataUtils metadataUtils;

    @Autowired
    public Transaction(ApplicationContext context) {
        this._searchController = new SearchController(context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        this.checkService(request);
        this.checkVersion(request);
        int totalInserted = 0;
        int totalUpdated = 0;
        int totalDeleted = 0;
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        ArrayList<InsertedMetadata> inserted = new ArrayList<InsertedMetadata>();
        List childList = request.getChildren();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        HashSet<String> toIndex = new HashSet<String>();
        try {
            for (Element transRequest : childList) {
                String transactionType = transRequest.getName().toLowerCase();
                if (!transactionType.equals("insert") && !transactionType.equals("update") && !transactionType.equals("delete")) continue;
                List mdList = transRequest.getChildren();
                if (transactionType.equals("insert")) {
                    for (Element aMdList : mdList) {
                        Element metadata = (Element)aMdList.clone();
                        boolean insertSuccess = this.insertTransaction(metadata, inserted, context, toIndex);
                        if (!insertSuccess) continue;
                        ++totalInserted;
                    }
                    continue;
                }
                if (transactionType.equals("update")) {
                    Element metadata = null;
                    for (Element reqElem : mdList) {
                        if (reqElem.getNamespace() == Csw.NAMESPACE_CSW) continue;
                        metadata = (Element)reqElem.clone();
                    }
                    totalUpdated = this.updateTransaction(transRequest, metadata, context, toIndex);
                    continue;
                }
                totalDeleted = this.deleteTransaction(transRequest, context);
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.csw", (Object)"Cannot process transaction");
            Log.error((String)"geonetwork.csw", (Object)(" (C) StackTrace\n" + Util.getStackTrace((Throwable)e)));
            throw new NoApplicableCodeEx("Cannot process transaction: " + e.getMessage());
        }
        finally {
            try {
                dataMan.indexMetadata(new ArrayList(toIndex));
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.csw", (Object)"cannot index");
                Log.error((String)"geonetwork.csw", (Object)(" (C) StackTrace\n" + Util.getStackTrace((Throwable)e)));
            }
            this.getResponseResult(context, request, response, inserted, totalInserted, totalUpdated, totalDeleted);
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) {
        return new Element(this.getName(), Csw.NAMESPACE_CSW);
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private boolean insertTransaction(Element xml, List<InsertedMetadata> documents, ServiceContext context, Set<String> toIndex) throws Exception {
        SettingManager sm;
        boolean metadataPublic;
        UserSession us;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        String schema = dataMan.autodetectSchema(xml);
        String category = null;
        String source = null;
        String createDate = null;
        String changeDate = null;
        String uuid = dataMan.extractUUID(schema, xml);
        if (uuid.length() == 0) {
            uuid = UUID.randomUUID().toString();
        }
        if ((us = context.getUserSession()).getUserId() == null) {
            throw new NoApplicableCodeEx("User not authenticated.");
        }
        Profile profile = us.getProfile();
        if (profile != Profile.Editor && profile != Profile.Reviewer && profile != Profile.UserAdmin && profile != Profile.Administrator) {
            throw new NoApplicableCodeEx("User not allowed to insert metadata.");
        }
        int userId = us.getUserIdAsInt();
        AccessManager am = (AccessManager)gc.getBean(AccessManager.class);
        Set userGroups = am.getVisibleGroups(userId);
        String group = userGroups.isEmpty() ? null : ((Integer)userGroups.iterator().next()).toString();
        String docType = null;
        String isTemplate = null;
        boolean ufo = true;
        boolean indexImmediate = false;
        String id = dataMan.insertMetadata(context, schema, xml, uuid, userId, group, source, isTemplate, docType, category, createDate, changeDate, ufo, indexImmediate);
        if (group != null) {
            for (ReservedOperation op : ReservedOperation.values()) {
                dataMan.unsetOperation(context, id, group, op);
            }
        }
        if (metadataPublic = (sm = (SettingManager)gc.getBean(SettingManager.class)).getValueAsBool("system/csw/metadataPublic", false)) {
            dataMan.setOperation(context, id, "" + ReservedGroup.all.getId(), ReservedOperation.view);
            dataMan.setOperation(context, id, "" + ReservedGroup.all.getId(), ReservedOperation.download);
            dataMan.setOperation(context, id, "" + ReservedGroup.all.getId(), ReservedOperation.dynamic);
        }
        dataMan.indexMetadata(id, true, null);
        documents.add(new InsertedMetadata(schema, id, xml));
        toIndex.add(id);
        return true;
    }

    private int updateTransaction(Element request, Element xml, ServiceContext context, Set<String> toIndex) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        if (context.getUserSession().getUserId() == null) {
            throw new NoApplicableCodeEx("User not authenticated.");
        }
        int totalUpdated = 0;
        if (xml != null) {
            String schemaId = ((SchemaManager)gc.getBean(SchemaManager.class)).autodetectSchema(xml);
            if (schemaId == null) {
                throw new NoApplicableCodeEx("Can't identify metadata schema");
            }
            String uuid = ((DataManager)gc.getBean(DataManager.class)).extractUUID(schemaId, xml);
            if (uuid.length() == 0) {
                throw new NoApplicableCodeEx("Metadata identifier not provided");
            }
            String id = dataMan.getMetadataId(uuid);
            if (id == null) {
                return totalUpdated;
            }
            if (!((AccessManager)gc.getBean(AccessManager.class)).canEdit(context, id)) {
                throw new NoApplicableCodeEx("User not allowed to update this metadata(" + id + ").");
            }
            String changeDate = null;
            try {
                changeDate = this.metadataUtils.extractDateModified(schemaId, xml);
            }
            catch (Exception ex) {
                changeDate = new ISODate().toString();
            }
            boolean validate = false;
            boolean ufo = false;
            boolean index = false;
            String language = context.getLanguage();
            dataMan.updateMetadata(context, id, xml, validate, ufo, index, language, changeDate, true);
            toIndex.add(id);
            return ++totalUpdated;
        }
        List constraints = request.getChildren("Constraint", Csw.NAMESPACE_CSW);
        Assert.isTrue((constraints.size() == 1 ? 1 : 0) != 0, (String)("One and only 1 constraint allowed in update query.  Found : " + constraints.size()));
        Element constr = (Element)((Element)constraints.get(0)).clone();
        List<Element> results = this.getResultsFromConstraints(context, constr);
        List recordProperties = request.getChildren("RecordProperty", Csw.NAMESPACE_CSW);
        Iterator<Element> it = results.iterator();
        if (!it.hasNext()) {
            return totalUpdated;
        }
        HashSet<String> updatedMd = new HashSet<String>();
        while (it.hasNext()) {
            Element result = it.next();
            String uuid = result.getChildText("identifier", Csw.NAMESPACE_DC);
            String id = dataMan.getMetadataId(uuid);
            String changeDate = null;
            if (id == null) continue;
            if (!dataMan.getAccessManager().canEdit(context, id)) {
                throw new NoApplicableCodeEx("User not allowed to update this metadata(" + id + ").");
            }
            Element metadata = dataMan.getMetadata(context, id, false, false, true);
            metadata.removeChild("info", Edit.NAMESPACE);
            String schemaId = ((DataManager)gc.getBean(DataManager.class)).autodetectSchema(metadata);
            if (schemaId == null) {
                throw new NoApplicableCodeEx("Can't identify metadata schema");
            }
            boolean metadataChanged = false;
            EditLib editLib = new EditLib(this._schemaManager);
            MetadataSchema metadataSchema = this._schemaManager.getSchema(schemaId);
            String settingId = "system/csw/transactionUpdateCreateXPath";
            boolean createXpathNodeIfNotExists = ((SettingManager)gc.getBean(SettingManager.class)).getValueAsBool("system/csw/transactionUpdateCreateXPath");
            for (Element recordProperty : recordProperties) {
                AddElemValue propertyValue;
                Element propertyNameEl = recordProperty.getChild("Name", Csw.NAMESPACE_CSW);
                Element propertyValueEl = recordProperty.getChild("Value", Csw.NAMESPACE_CSW);
                String propertyName = propertyNameEl.getText();
                String xpathProperty = this._fieldMapper.mapXPath(propertyName, schemaId);
                if (xpathProperty == null) {
                    xpathProperty = propertyName;
                }
                Log.info((String)"geonetwork.csw", (Object)("Xpath of property: " + xpathProperty));
                List children = propertyValueEl.getChildren();
                if (children.isEmpty()) {
                    propertyValue = new AddElemValue(propertyValueEl.getText());
                    metadataChanged |= editLib.addElementOrFragmentFromXpath(metadata, metadataSchema, xpathProperty, propertyValue, createXpathNodeIfNotExists);
                } else {
                    for (Element child : children) {
                        propertyValue = new AddElemValue((Element)child.clone());
                        metadataChanged |= editLib.addElementOrFragmentFromXpath(metadata, metadataSchema, xpathProperty, propertyValue, createXpathNodeIfNotExists);
                    }
                }
                Log.info((String)"geonetwork.csw", (Object)("Metadata has been updated: " + metadataChanged));
            }
            if (!metadataChanged) continue;
            boolean validate = false;
            boolean ufo = false;
            boolean index = false;
            try {
                changeDate = this.metadataUtils.extractDateModified(schemaId, metadata);
            }
            catch (Exception ex) {
                changeDate = new ISODate().toString();
            }
            String language = context.getLanguage();
            dataMan.updateMetadata(context, id, metadata, validate, ufo, index, language, changeDate, true);
            updatedMd.add(id);
            ++totalUpdated;
        }
        toIndex.addAll(updatedMd);
        return totalUpdated;
    }

    private int deleteTransaction(Element request, ServiceContext context) throws Exception {
        int deleted = 0;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        IMetadataManager metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        if (context.getUserSession().getUserId() == null) {
            throw new NoApplicableCodeEx("User not authenticated.");
        }
        Element constr = request.getChild("Constraint", Csw.NAMESPACE_CSW);
        List<Element> results = this.getResultsFromConstraints(context, constr);
        Iterator<Element> i = results.iterator();
        if (!i.hasNext()) {
            return deleted;
        }
        while (i.hasNext()) {
            Element result = i.next();
            String uuid = result.getChildText("identifier", Csw.NAMESPACE_DC);
            String id = dataMan.getMetadataId(uuid);
            if (id == null) {
                return deleted;
            }
            if (!dataMan.getAccessManager().canEdit(context, id)) {
                throw new NoApplicableCodeEx("User not allowed to delete metadata : " + id);
            }
            metadataManager.deleteMetadata(context, id);
            ++deleted;
        }
        return deleted;
    }

    private List<Element> getResultsFromConstraints(ServiceContext context, Element constr) throws CatalogException {
        Element filterExpr = this.getFilterExpression(constr);
        String filterVersion = this.getFilterVersion(constr);
        ElementSetName setName = ElementSetName.BRIEF;
        Pair<Element, Element> results = this._searchController.search(context, 1, 100, ResultType.RESULTS, OutputSchema.DEFAULT.toString(), setName, filterExpr, filterVersion, null, null, null, 0, null, null);
        List children = ((Element)results.two()).getChildren();
        return children;
    }

    private void getResponseResult(ServiceContext context, Element request, Element response, List<InsertedMetadata> inserted, int totalInserted, int totalUpdated, int totalDeleted) {
        Element transactionSummary = this.getTransactionSummary(totalInserted, totalUpdated, totalDeleted);
        String strRequestId = request.getAttributeValue("requestId");
        if (strRequestId != null) {
            transactionSummary.setAttribute("requestId", strRequestId);
        }
        response.addContent((Content)transactionSummary);
        if (totalInserted > 0) {
            Element insertResult = new Element("InsertResult", Csw.NAMESPACE_CSW);
            insertResult.setAttribute("handleRef", "handleRefValue");
            for (InsertedMetadata md : inserted) {
                Element briefRecord;
                try {
                    briefRecord = Transaction.applyCswBrief(context, this._schemaManager, md.schema, md.content, md.id, context.getLanguage());
                }
                catch (Exception e) {
                    Log.warning((String)"geonetwork.csw", (Object)("Error transforming metadata: " + md.id), (Throwable)e);
                    briefRecord = new Element("BriefRecord", Csw.NAMESPACE_CSW);
                    Element identifier = new Element("identifier", Csw.NAMESPACE_DC);
                    identifier.setText(md.id);
                    briefRecord.addContent((Content)identifier);
                }
                insertResult.addContent((Content)briefRecord);
            }
            response.addContent((Content)insertResult);
        }
    }

    private static Element applyCswBrief(ServiceContext context, SchemaManager schemaManager, String schema, Element md, String id, String displayLanguage) throws Exception {
        return Xml.applyElementSetName(context, schemaManager, schema, md, "csw", ElementSetName.BRIEF, ResultType.RESULTS, id, displayLanguage);
    }

    private Element getTransactionSummary(int totalInserted, int totalUpdated, int totalDeleted) {
        Element transactionSummary = new Element("TransactionSummary", Csw.NAMESPACE_CSW);
        Element insert = new Element("totalInserted", Csw.NAMESPACE_CSW);
        insert.setText(Integer.toString(totalInserted));
        transactionSummary.addContent((Content)insert);
        Element update = new Element("totalUpdated", Csw.NAMESPACE_CSW);
        update.setText(Integer.toString(totalUpdated));
        transactionSummary.addContent((Content)update);
        Element delete = new Element("totalDeleted", Csw.NAMESPACE_CSW);
        delete.setText(Integer.toString(totalDeleted));
        transactionSummary.addContent((Content)delete);
        return transactionSummary;
    }

    static class InsertedMetadata {
        String schema;
        String id;
        Element content;

        public InsertedMetadata(String schema, String id, Element content) {
            this.schema = schema;
            this.id = id;
            this.content = content;
        }
    }
}

