/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import org.geotools.image.palette.InverseColorMapRasterOp;

public class ColorInversion
extends PointOpImage {
    private InverseColorMapRasterOp op;

    public ColorInversion(RenderedImage image, IndexColorModel icm, int quantizationColors, int alpaThreshold) {
        super(image, new ImageLayout(image), null, false);
        this.setSource(image, 0);
        this.op = new InverseColorMapRasterOp(icm, quantizationColors, alpaThreshold);
        this.setImageLayout(new ImageLayout(image).setColorModel((ColorModel)icm).setSampleModel(icm.createCompatibleSampleModel(image.getWidth(), image.getHeight())));
    }

    public Raster computeTile(int tx, int ty) {
        PlanarImage sourceImage = this.getSourceImage(0);
        Raster sourceRaster = sourceImage.getTile(tx, ty);
        return this.op.filter(sourceRaster, null);
    }
}

