/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN = null;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String PREFIX = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public UsingInstrumentation(File folder, Target target, Instrumentation instrumentation) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = new RandomString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, String.format("%s%s.jar", PREFIX, this.randomString.nextString()));
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap(types.size());
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
                }
                return loaded;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot write jar file to disk", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load injected class", e);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingInstrumentation that = (UsingInstrumentation)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation) && this.target == that.target;
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + this.folder.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingInstrumentation{instrumentation=" + this.instrumentation + ", target=" + (Object)((Object)this.target) + ", folder=" + this.folder + ", randomString=" + this.randomString + '}';
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);

            public String toString() {
                return "ClassInjector.UsingInstrumentation.Target." + this.name();
            }
        }
    }

    public static class UsingReflection
    implements ClassInjector {
        private static final ReflectionStore REFLECTION_STORE;
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;
        private final AccessControlContext accessControlContext;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, DEFAULT_PROTECTION_DOMAIN);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.accessControlContext = AccessController.getContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            try {
                HashMap loaded = new HashMap(types.size());
                ClassLoader classLoader = this.classLoader;
                synchronized (classLoader) {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        Class type = (Class)REFLECTION_STORE.getFindLoadedClassMethod().invoke((Object)this.classLoader, entry.getKey().getName());
                        if (type == null) {
                            try {
                                type = (Class)AccessController.doPrivileged(new ClassLoadingAction(entry.getKey().getName(), entry.getValue()), this.accessControlContext);
                            }
                            catch (PrivilegedActionException e) {
                                if (e.getCause() instanceof IllegalAccessException) {
                                    throw (IllegalAccessException)e.getCause();
                                }
                                if (e.getCause() instanceof InvocationTargetException) {
                                    throw (InvocationTargetException)e.getCause();
                                }
                                throw (RuntimeException)e.getCause();
                            }
                        }
                        loaded.put(entry.getKey(), type);
                    }
                }
                return loaded;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not access injection method", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Exception on invoking loader method", e.getCause());
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingReflection that = (UsingReflection)other;
            return this.accessControlContext.equals(that.accessControlContext) && this.classLoader.equals(that.classLoader) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain));
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
            result = 31 * result + this.accessControlContext.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingReflection{classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", accessControlContext=" + this.accessControlContext + '}';
        }

        static {
            ReflectionStore reflectionStore;
            try {
                Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                findLoadedClassMethod.setAccessible(true);
                Method loadByteArrayMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                loadByteArrayMethod.setAccessible(true);
                reflectionStore = new ReflectionStore.Resolved(findLoadedClassMethod, loadByteArrayMethod);
            }
            catch (Exception e) {
                reflectionStore = new ReflectionStore.Faulty(e);
            }
            REFLECTION_STORE = reflectionStore;
        }

        protected class ClassLoadingAction
        implements PrivilegedExceptionAction<Class<?>> {
            private static final int FROM_BEGINNING = 0;
            private final String name;
            private final byte[] binaryRepresentation;

            protected ClassLoadingAction(String name, byte[] binaryRepresentation) {
                this.name = name;
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public Class<?> run() throws IllegalAccessException, InvocationTargetException {
                return (Class)REFLECTION_STORE.getLoadByteArrayMethod().invoke((Object)UsingReflection.this.classLoader, this.name, this.binaryRepresentation, 0, this.binaryRepresentation.length, UsingReflection.this.protectionDomain);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ClassLoadingAction that = (ClassLoadingAction)other;
                return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation) && UsingReflection.this.equals(that.getOuter()) && this.name.equals(that.name);
            }

            private UsingReflection getOuter() {
                return UsingReflection.this;
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + UsingReflection.this.hashCode();
                result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                return result;
            }

            public String toString() {
                return "ClassInjector.UsingReflection.ClassLoadingAction{injector=" + UsingReflection.this + ", name='" + this.name + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        protected static interface ReflectionStore {
            public Method getFindLoadedClassMethod();

            public Method getLoadByteArrayMethod();

            public static class Faulty
            implements ReflectionStore {
                private static final String MESSAGE = "Cannot access reflection API for class loading";
                private final Exception exception;

                protected Faulty(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public Method getFindLoadedClassMethod() {
                    throw new RuntimeException(MESSAGE, this.exception);
                }

                @Override
                public Method getLoadByteArrayMethod() {
                    throw new RuntimeException(MESSAGE, this.exception);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Faulty)other).exception);
                }

                public int hashCode() {
                    return this.exception.hashCode();
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.ReflectionStore.Faulty{exception=" + this.exception + '}';
                }
            }

            public static class Resolved
            implements ReflectionStore {
                private final Method findLoadedClassMethod;
                private final Method loadByteArrayMethod;

                protected Resolved(Method findLoadedClassMethod, Method loadByteArrayMethod) {
                    this.findLoadedClassMethod = findLoadedClassMethod;
                    this.loadByteArrayMethod = loadByteArrayMethod;
                }

                @Override
                public Method getFindLoadedClassMethod() {
                    return this.findLoadedClassMethod;
                }

                @Override
                public Method getLoadByteArrayMethod() {
                    return this.loadByteArrayMethod;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.findLoadedClassMethod.equals(resolved.findLoadedClassMethod) && this.loadByteArrayMethod.equals(resolved.loadByteArrayMethod);
                }

                public int hashCode() {
                    int result = this.findLoadedClassMethod.hashCode();
                    result = 31 * result + this.loadByteArrayMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.ReflectionStore.Resolved{findLoadedClassMethod=" + this.findLoadedClassMethod + ", loadByteArrayMethod=" + this.loadByteArrayMethod + '}';
                }
            }
        }
    }
}

