/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteRetriever;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavParams;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavRemoteFile;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;

class WebDavRetriever
implements RemoteRetriever {
    private Logger log;
    private ServiceContext context;
    private WebDavParams params;
    private List<RemoteFile> files = new ArrayList<RemoteFile>();
    private Sardine sardine;
    private AtomicBoolean cancelMonitor;

    WebDavRetriever() {
    }

    static String calculateBaseURL(AtomicBoolean cancelMonitor, String url, List<DavResource> resources) throws IOException {
        Iterator<DavResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            if (cancelMonitor.get()) {
                return "";
            }
            DavResource next = iterator.next();
            if (!url.endsWith(next.getPath())) continue;
            iterator.remove();
            return url.substring(0, url.length() - next.getPath().length());
        }
        return url;
    }

    @Override
    public void init(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, WebDavParams params) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
    }

    @Override
    public List<RemoteFile> retrieve() throws Exception {
        HttpClientBuilder clientBuilder = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).getDefaultHttpClientBuilder();
        Lib.net.setupProxy(this.context, clientBuilder, new URL(this.params.url).getHost());
        this.sardine = this.params.isUseAccount() ? new SardineImpl(clientBuilder, this.params.getUsername(), this.params.getPassword()) : new SardineImpl(clientBuilder);
        this.files.clear();
        String url = this.params.url;
        if (!url.endsWith("/")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("URL " + url + "does not end in slash -- will be appended");
            }
            url = url + "/";
        }
        List<DavResource> resources = this.open(url);
        url = WebDavRetriever.calculateBaseURL(this.cancelMonitor, url, resources);
        for (DavResource resource : resources) {
            if (this.cancelMonitor.get()) {
                return Collections.emptyList();
            }
            this.retrieveFile(url, resource);
        }
        return this.files;
    }

    @Override
    public void destroy() {
        try {
            this.sardine.shutdown();
        }
        catch (Exception e) {
            this.log.warning("Cannot close resource : " + e.getMessage());
        }
    }

    private List<DavResource> open(String url) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("opening webdav resource with URL: " + url);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to webdav url for node : " + this.params.getName() + " URL: " + this.params.url);
        }
        List davResources = this.sardine.list(url, 1, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("# " + davResources.size() + " webdav resources found in: " + url);
        }
        return davResources;
    }

    private void retrieveFile(String baseURL, DavResource davResource) throws IOException {
        int endSize;
        int added;
        if (this.cancelMonitor.get()) {
            this.files.clear();
            return;
        }
        String path = davResource.getPath();
        int startSize = this.files.size();
        if (davResource.isDirectory()) {
            if (this.params.recurse) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(path + " is a collection, processed recursively");
                }
                for (DavResource resource : this.sardine.list(baseURL + path)) {
                    if (resource.getHref().equals(davResource.getHref())) continue;
                    this.retrieveFile(baseURL, resource);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(path + " is a collection. Ignoring because recursion is disabled.");
            }
        } else {
            String name;
            if (this.log.isDebugEnabled()) {
                this.log.debug(path + " is not a collection");
            }
            if ((name = davResource.getName()).toLowerCase().endsWith(".xml")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found xml file ! " + name.toLowerCase());
                }
                this.files.add(new WebDavRemoteFile(this.sardine, baseURL, davResource));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(name.toLowerCase() + " is not an xml file");
            }
        }
        if ((added = (endSize = this.files.size()) - startSize) == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No xml files found in path : " + path);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Found " + added + " xml file(s) in path : " + path);
        }
    }
}

