/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.localfilesystem;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.localfilesystem.LocalFilesystemParams;
import org.fao.geonet.kernel.harvest.harvester.localfilesystem.LocalFsHarvesterFileVisitor;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.IO;
import org.jdom.Element;

public class LocalFilesystemHarvester
extends AbstractHarvester<HarvestResult, LocalFilesystemParams> {
    @Override
    protected void storeNodeExtra(LocalFilesystemParams params, String path, String siteId, String optionsId) throws SQLException {
        this.setParams(params);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"icon", (Object)params.icon);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"recurse", (Object)params.recurse);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"directory", (Object)params.directoryname);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"recordType", (Object)params.recordType);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"nodelete", (Object)params.nodelete);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"checkFileLastModifiedForUpdate", (Object)params.checkFileLastModifiedForUpdate);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"beforeScript", (Object)params.beforeScript);
    }

    @Override
    protected LocalFilesystemParams createParams() {
        return new LocalFilesystemParams(this.dataMan);
    }

    private HarvestResult align(Path root) throws Exception {
        this.log.debug("Start of alignment for : " + ((LocalFilesystemParams)this.params).getName());
        LocalFsHarvesterFileVisitor visitor = new LocalFsHarvesterFileVisitor(this.cancelMonitor, this.context, (LocalFilesystemParams)this.params, this);
        if (((LocalFilesystemParams)this.params).recurse) {
            Files.walkFileTree(root, visitor);
        } else {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(root);){
                for (Path path : paths) {
                    if (path == null || !Files.isRegularFile(path, new LinkOption[0])) continue;
                    visitor.visitFile(path, Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
                }
            }
        }
        this.result = visitor.getResult();
        this.log.debug(String.format("Scan directory is done. %d files analyzed.", this.result.totalMetadata));
        Set<Integer> idsForHarvestingResult = visitor.getListOfRecords();
        HashSet idsResultHs = Sets.newHashSet(idsForHarvestingResult);
        if (!((LocalFilesystemParams)this.params).nodelete) {
            this.log.debug("Starting to delete locally existing metadata from the same source if they  were not in this harvesting result...");
            List existingMetadata = ((MetadataRepository)this.context.getBean(MetadataRepository.class)).findAllIdsBy(MetadataSpecs.hasHarvesterUuid((String)((LocalFilesystemParams)this.params).getUuid()));
            for (Integer existingId : existingMetadata) {
                if (this.cancelMonitor.get()) {
                    return this.result;
                }
                if (idsResultHs.contains(existingId)) continue;
                this.log.debug("  Removing: " + existingId);
                this.metadataManager.deleteMetadata(this.context, existingId.toString());
                ++this.result.locallyRemoved;
            }
        }
        this.log.debug("Starting indexing in batch thread pool...");
        ArrayList listOfRecordsToIndex = Lists.newArrayList(visitor.getListOfRecordsToIndex());
        this.log.debug(String.format("Starting indexing in batch thread pool of %d updated records ...", listOfRecordsToIndex.size()));
        this.dataMan.batchIndexInThreadPool(this.context, (List)listOfRecordsToIndex);
        this.log.debug("End of alignment for : " + ((LocalFilesystemParams)this.params).getName());
        return this.result;
    }

    void updateMetadata(Element xml, String id, GroupMapper localGroups, CategoryMapper localCateg, String changeDate, BaseAligner<LocalFilesystemParams> aligner, boolean force) throws Exception {
        this.log.debug("  - Updating metadata with id: " + id);
        String language = this.context.getLanguage();
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, xml, false, false, false, language, changeDate, true);
        if (force) {
            this.log.debug(String.format("  - Changing source of metadata id %s to '%s' harvester", id, ((LocalFilesystemParams)this.params).getName()));
            metadata.getHarvestInfo().setUuid(((LocalFilesystemParams)this.params).getUuid());
            metadata.getSourceInfo().setSourceId(((LocalFilesystemParams)this.params).getUuid());
            this.metadataManager.save(metadata);
        }
        OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
        repository.deleteAllByMetadataId(Integer.parseInt(id));
        aligner.addPrivileges(id, ((LocalFilesystemParams)this.params).getPrivileges(), localGroups, this.context);
        metadata.getCategories().clear();
        aligner.addCategories(metadata, ((LocalFilesystemParams)this.params).getCategories(), localCateg, this.context, null, true);
        this.metadataManager.flush();
        this.dataMan.indexMetadata(id, true, null);
    }

    String addMetadata(Element xml, String uuid, String schema, GroupMapper localGroups, CategoryMapper localCateg, String createDate, BaseAligner aligner, boolean index) throws Exception {
        this.log.debug("  - Adding metadata with remote uuid: " + uuid);
        Element md = xml;
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        String xmlUuid = this.metadataUtils.extractUUID(schema, md);
        if (!uuid.equals(xmlUuid)) {
            md = this.metadataUtils.setUUID(schema, uuid, md);
        }
        metadata.getDataInfo().setSchemaId(schema).setRoot(xml.getQualifiedName()).setType(MetadataType.lookup((String)((LocalFilesystemParams)this.params).recordType)).setCreateDate(new ISODate(createDate)).setChangeDate(new ISODate(createDate));
        metadata.getSourceInfo().setSourceId(((LocalFilesystemParams)this.params).getUuid()).setOwner(Integer.valueOf(aligner.getOwner())).setGroupOwner(Integer.valueOf(((LocalFilesystemParams)this.params).getOwnerIdGroup()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((LocalFilesystemParams)this.params).getUuid());
        aligner.addCategories((AbstractMetadata)metadata, ((LocalFilesystemParams)this.params).getCategories(), localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, true, false, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        aligner.addPrivileges(id, ((LocalFilesystemParams)this.params).getPrivileges(), localGroups, this.context);
        this.metadataManager.flush();
        if (index) {
            this.dataMan.indexMetadata(id, true, null);
        }
        return id;
    }

    @Override
    public void doHarvest(Logger l) throws Exception {
        this.log.debug("LocalFilesystem doHarvest: top directory is " + ((LocalFilesystemParams)this.params).directoryname + ", recurse is " + ((LocalFilesystemParams)this.params).recurse);
        this.runBeforeScript();
        Path directory = IO.toPath((String)((LocalFilesystemParams)this.params).directoryname, (String[])new String[0]);
        this.result = this.align(directory);
    }

    private void runBeforeScript() throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)((LocalFilesystemParams)this.params).beforeScript)) {
            return;
        }
        throw new InterruptedException("Script option is currently disabled.");
    }
}

